/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.PreparedExistentialHomomorphism;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackHomomorphismPattern;
import fr.lirmm.graphik.util.stream.filter.Filter;
import java.util.Collections;
import java.util.Set;

class NegFilter
implements Filter<Substitution> {
    private PreparedExistentialHomomorphism homomorphism;

    public NegFilter(InMemoryAtomSet head, Set<Variable> frontier, AtomSet data, RulesCompilation compilation) throws HomomorphismException {
        ConjunctiveQuery query = DefaultConjunctiveQueryFactory.instance().create(head, Collections.emptyList());
        this.homomorphism = BacktrackHomomorphismPattern.instance().prepareHomomorphism(query, frontier, data, compilation);
    }

    @Override
    public boolean filter(Substitution s) {
        try {
            return !this.homomorphism.exist(s);
        }
        catch (HomomorphismException e) {
            e.printStackTrace();
            throw new Error(e);
        }
    }
}

