/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.PreparedHomomorphism;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackIterator;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackIteratorData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.GraphBaseBackJumping;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.NoBackJumping;
import fr.lirmm.graphik.integraal.homomorphism.bbc.BCC;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.StatBootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.NFC2;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.NoForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import fr.lirmm.graphik.util.profiler.NoProfiler;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

class PreparedBacktrackHomomorphism
implements PreparedHomomorphism {
    BacktrackIteratorData data;

    public PreparedBacktrackHomomorphism(ConjunctiveQuery query, Set<Variable> variablesToParameterize, AtomSet data, RulesCompilation compilation) throws HomomorphismException {
        BCC bcc = new BCC(new GraphBaseBackJumping(), true);
        this.data = new BacktrackIteratorData(query.getAtomSet(), variablesToParameterize, Collections.emptySet(), data, query.getAnswerVariables(), bcc.getBCCScheduler(), StatBootstrapper.instance(), new NFC2(), bcc.getBCCBackJumping(), compilation, NoProfiler.instance());
    }

    public PreparedBacktrackHomomorphism(ConjunctiveQuery query, Set<Variable> variablesToParameterize, Collection<InMemoryAtomSet> negParts, AtomSet data, Scheduler scheduler, Bootstrapper bootstrapper, RulesCompilation compilation, Profiler profiler) throws HomomorphismException {
        this.data = new BacktrackIteratorData(query.getAtomSet(), variablesToParameterize, negParts, data, query.getAnswerVariables(), scheduler, bootstrapper, NoForwardChecking.instance(), NoBackJumping.instance(), compilation, profiler);
    }

    @Override
    public boolean exist(Substitution s) throws HomomorphismException {
        boolean val;
        CloseableIterator<Substitution> results = this.execute(s);
        try {
            val = results.hasNext();
        }
        catch (IteratorException e) {
            throw new HomomorphismException(e);
        }
        results.close();
        return val;
    }

    @Override
    public CloseableIterator<Substitution> execute(Substitution s) throws HomomorphismException {
        return new BacktrackIterator(this.data, s);
    }
}

