/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.TreeMapSubstitution;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.ArrayList;
import java.util.List;

class PureHomomorphismImpl
extends AbstractProfilable {
    private ArrayList<Atom> sourceCopy;
    private AtomSet target;
    private RulesCompilation compilation;
    private ArrayList<Integer> currentImagesPerLevel;
    private ArrayList<List<Substitution>> availableImage;
    private ArrayList<Substitution> currentSubstitutionPerLevel;
    private final Substitution initialSubstitution;

    public PureHomomorphismImpl(InMemoryAtomSet source, AtomSet target, RulesCompilation compilation, Substitution s) {
        this.compilation = compilation;
        this.target = target;
        this.sourceCopy = new ArrayList();
        CloseableIterator it = source.iterator();
        while (it.hasNext()) {
            this.sourceCopy.add((Atom)it.next());
        }
        int size = this.sourceCopy.size();
        this.availableImage = new ArrayList(size);
        this.currentImagesPerLevel = new ArrayList(size);
        this.currentSubstitutionPerLevel = new ArrayList(size + 1);
        for (int i = 0; i < size; ++i) {
            this.currentImagesPerLevel.add(-1);
            this.availableImage.add(null);
            this.currentSubstitutionPerLevel.add(null);
        }
        this.currentSubstitutionPerLevel.add(null);
        this.currentSubstitutionPerLevel.set(0, new TreeMapSubstitution());
        this.initialSubstitution = s;
    }

    public boolean exist() throws HomomorphismException {
        if (this.sourceCopy == null || !this.sourceCopy.iterator().hasNext()) {
            return true;
        }
        Profiler profiler = this.getProfiler();
        profiler.start("preprocessing time");
        boolean res = this.initialiseHomomorphism();
        profiler.stop("preprocessing time");
        if (res) {
            profiler.start("backtracking time");
            res = this.backtrack();
            profiler.stop("backtracking time");
        }
        return res;
    }

    protected boolean initialiseHomomorphism() throws HomomorphismException {
        try {
            return this.initialiseAvailableImage(this.target);
        }
        catch (IteratorException e) {
            throw new HomomorphismException("An errors occurs while initializing available images for homomorphism", e);
        }
    }

    protected boolean backtrack() {
        int level = 0;
        while (level >= 0 && level < this.sourceCopy.size()) {
            Substitution nextCandidate = this.getNextCandidate(level);
            if (nextCandidate != null) {
                boolean foundImage = this.checkCurrentCandidate(level, nextCandidate);
                if (!foundImage) continue;
                ++level;
                continue;
            }
            --level;
        }
        return level >= 0;
    }

    protected boolean checkCurrentCandidate(int level, Substitution candidate) {
        Substitution newSub = Substitutions.add(this.currentSubstitutionPerLevel.get(level), candidate);
        if (newSub != null) {
            this.currentSubstitutionPerLevel.set(level + 1, newSub);
            return true;
        }
        return false;
    }

    protected Substitution getNextCandidate(int level) {
        Integer numCurrentImage;
        Integer n = numCurrentImage = this.currentImagesPerLevel.get(level);
        numCurrentImage = numCurrentImage + 1;
        List<Substitution> images = this.availableImage.get(level);
        if (numCurrentImage < images.size()) {
            this.currentImagesPerLevel.set(level, numCurrentImage);
            return images.get(numCurrentImage);
        }
        this.currentImagesPerLevel.set(level, -1);
        return null;
    }

    protected boolean initialiseAvailableImage(CloseableIterable<Atom> target) throws IteratorException {
        for (int i = 0; i < this.sourceCopy.size(); ++i) {
            Atom atomSource = this.sourceCopy.get(i);
            ArrayList<Substitution> images = new ArrayList<Substitution>();
            CloseableIterator<Atom> it = target.iterator();
            while (it.hasNext()) {
                Atom im = it.next();
                for (Substitution s : this.compilation.homomorphism(atomSource, im, this.initialSubstitution)) {
                    images.add(s);
                }
            }
            it.close();
            if (images.isEmpty()) {
                return false;
            }
            this.availableImage.set(i, images);
        }
        return true;
    }
}

