/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.homomorphism.ExistentialHomomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismChecker;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.core.compilation.NoCompilation;
import fr.lirmm.graphik.integraal.homomorphism.checker.AtomicQueryHomomorphismChecker;
import fr.lirmm.graphik.integraal.homomorphism.checker.AtomicQueryHomomorphismWithNegatedPartsChecker;
import fr.lirmm.graphik.integraal.homomorphism.checker.BacktrackChecker;
import fr.lirmm.graphik.integraal.homomorphism.checker.BacktrackWithNegatedPartsChecker;
import fr.lirmm.graphik.integraal.homomorphism.checker.DefaultUnionConjunctiveQueriesChecker;
import fr.lirmm.graphik.integraal.homomorphism.checker.FullyInstantiatedQueryHomomorphismChecker;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SmartHomomorphism
extends AbstractProfilable
implements HomomorphismWithCompilation<Object, AtomSet> {
    private SortedSet<HomomorphismChecker> elements = new TreeSet<HomomorphismChecker>();
    private static SmartHomomorphism instance;

    public SmartHomomorphism(boolean loadDefaultHomomorphism) {
        if (loadDefaultHomomorphism) {
            this.elements.add(BacktrackChecker.instance());
            this.elements.add(DefaultUnionConjunctiveQueriesChecker.instance());
            this.elements.add(FullyInstantiatedQueryHomomorphismChecker.instance());
            this.elements.add(AtomicQueryHomomorphismChecker.instance());
            this.elements.add(BacktrackWithNegatedPartsChecker.instance());
            this.elements.add(AtomicQueryHomomorphismWithNegatedPartsChecker.instance());
        }
    }

    public static synchronized SmartHomomorphism instance() {
        if (instance == null) {
            instance = new SmartHomomorphism(true);
        }
        return instance;
    }

    public boolean addChecker(HomomorphismChecker checker) {
        return this.elements.add(checker);
    }

    @Override
    public CloseableIterator<Substitution> execute(Object query, AtomSet atomSet) throws HomomorphismException {
        for (HomomorphismChecker e : this.elements) {
            if (!e.check(query, atomSet)) continue;
            ExistentialHomomorphism solver = e.getSolver();
            return solver.execute(query, atomSet);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public CloseableIterator<Substitution> execute(Object query, AtomSet atomSet, Substitution s) throws HomomorphismException {
        for (HomomorphismChecker e : this.elements) {
            if (!e.check(query, atomSet)) continue;
            ExistentialHomomorphism solver = e.getSolver();
            return solver.execute(query, atomSet, s);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public boolean exist(Object query, AtomSet atomSet) throws HomomorphismException {
        for (HomomorphismChecker e : this.elements) {
            if (!e.check(query, atomSet)) continue;
            ExistentialHomomorphism solver = e.getSolver();
            return solver.exist(query, atomSet);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public boolean exist(Object query, AtomSet atomSet, Substitution s) throws HomomorphismException {
        for (HomomorphismChecker e : this.elements) {
            if (!e.check(query, atomSet)) continue;
            ExistentialHomomorphism solver = e.getSolver();
            return solver.exist(query, atomSet, s);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public CloseableIterator<Substitution> execute(Object query, AtomSet atomSet, RulesCompilation compilation) throws HomomorphismException {
        if (compilation == null || compilation.isEmpty()) {
            return this.execute(query, atomSet);
        }
        for (HomomorphismChecker e : this.elements) {
            if (!(e.getSolver() instanceof HomomorphismWithCompilation) || !e.check(query, atomSet)) continue;
            HomomorphismWithCompilation solver = (HomomorphismWithCompilation)e.getSolver();
            return solver.execute(query, atomSet, compilation);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public CloseableIterator<Substitution> execute(Object query, AtomSet atomSet, RulesCompilation compilation, Substitution s) throws HomomorphismException {
        if (compilation == null || compilation == NoCompilation.instance()) {
            return this.execute(query, atomSet);
        }
        for (HomomorphismChecker e : this.elements) {
            if (!(e.getSolver() instanceof HomomorphismWithCompilation) || !e.check(query, atomSet)) continue;
            HomomorphismWithCompilation solver = (HomomorphismWithCompilation)e.getSolver();
            return solver.execute(query, atomSet, compilation, s);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public boolean exist(Object query, AtomSet atomSet, RulesCompilation compilation) throws HomomorphismException {
        if (compilation == null || compilation == NoCompilation.instance()) {
            return this.exist(query, atomSet);
        }
        for (HomomorphismChecker e : this.elements) {
            if (!(e.getSolver() instanceof HomomorphismWithCompilation) || !e.check(query, atomSet)) continue;
            HomomorphismWithCompilation solver = (HomomorphismWithCompilation)e.getSolver();
            return solver.exist(query, atomSet, compilation);
        }
        throw new HomomorphismException("Solver not found");
    }

    @Override
    public boolean exist(Object query, AtomSet atomSet, RulesCompilation compilation, Substitution s) throws HomomorphismException {
        if (compilation == null || compilation == NoCompilation.instance()) {
            return this.exist(query, atomSet);
        }
        for (HomomorphismChecker e : this.elements) {
            if (!(e.getSolver() instanceof HomomorphismWithCompilation) || !e.check(query, atomSet)) continue;
            HomomorphismWithCompilation solver = (HomomorphismWithCompilation)e.getSolver();
            return solver.exist(query, atomSet, compilation, s);
        }
        throw new HomomorphismException("Solver not found");
    }
}

