/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.EffectiveConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.UnionOfConjunctiveQueries;
import fr.lirmm.graphik.integraal.api.homomorphism.Homomorphism;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismWithCompilation;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.compilation.NoCompilation;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.integraal.homomorphism.SmartHomomorphism;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;

class UnionConjunctiveQueriesSubstitutionIterator
extends AbstractProfilable
implements CloseableIterator<Substitution> {
    private AtomSet atomSet;
    private CloseableIterator<EffectiveConjunctiveQuery> cqueryIterator;
    private CloseableIterator<Substitution> tmpIt;
    private boolean hasNextCallDone = false;
    private Homomorphism<ConjunctiveQuery, AtomSet> homomorphism;
    private RulesCompilation compilation;
    private Substitution initialSubstitution;
    private int i = 1;
    private boolean isBooleanQuery;

    public UnionConjunctiveQueriesSubstitutionIterator(UnionOfConjunctiveQueries queries, AtomSet atomSet) {
        this(queries, atomSet, Substitutions.emptySubstitution(), null, null);
    }

    public UnionConjunctiveQueriesSubstitutionIterator(UnionOfConjunctiveQueries queries, AtomSet atomSet, Substitution s, Homomorphism<ConjunctiveQuery, AtomSet> homomorphism) {
        this.cqueryIterator = queries.iterator();
        this.isBooleanQuery = queries.isBoolean();
        this.atomSet = atomSet;
        this.tmpIt = null;
        this.initialSubstitution = s;
        this.homomorphism = homomorphism;
        this.compilation = null;
    }

    public UnionConjunctiveQueriesSubstitutionIterator(UnionOfConjunctiveQueries queries, AtomSet atomSet, Substitution s, HomomorphismWithCompilation<ConjunctiveQuery, AtomSet> homomorphism, RulesCompilation rc) {
        this.cqueryIterator = queries.iterator();
        this.isBooleanQuery = queries.isBoolean();
        this.atomSet = atomSet;
        this.tmpIt = null;
        this.initialSubstitution = s;
        this.homomorphism = homomorphism;
        this.compilation = rc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasNext() throws IteratorException {
        if (!this.hasNextCallDone) {
            this.hasNextCallDone = true;
            if (this.tmpIt != null && !this.tmpIt.hasNext()) {
                this.tmpIt.close();
                this.tmpIt = null;
                this.getProfiler().stop("SubQuery" + this.i++);
            }
            while ((this.tmpIt == null || !this.tmpIt.hasNext()) && this.cqueryIterator.hasNext()) {
                EffectiveConjunctiveQuery ecq = this.cqueryIterator.next();
                Object ecqSubstitution = ecq.getSubstitution();
                ConjunctiveQuery ecqQuery = (ConjunctiveQuery)ecq.getQuery();
                Substitution partialSubstitution = DefaultSubstitutionFactory.instance().createSubstitution(this.initialSubstitution);
                if (ecqSubstitution != null) {
                    partialSubstitution.put((Substitution)ecqSubstitution);
                }
                this.getProfiler().start("SubQuery" + this.i);
                try {
                    if (this.homomorphism == null) {
                        this.tmpIt = SmartHomomorphism.instance().execute(ecqQuery, this.atomSet, this.compilation, partialSubstitution);
                    } else if (this.compilation != null && !(this.compilation instanceof NoCompilation)) {
                        if (!(this.homomorphism instanceof HomomorphismWithCompilation)) throw new IteratorException("There is a compilation and selected homomorphism can't handle it : " + this.homomorphism.getClass());
                        this.tmpIt = ((HomomorphismWithCompilation)this.homomorphism).execute(ecqQuery, this.atomSet, this.compilation, partialSubstitution);
                    } else {
                        this.tmpIt = this.homomorphism.execute(ecqQuery, this.atomSet, partialSubstitution);
                    }
                    if (!this.isBooleanQuery || !this.tmpIt.hasNext()) continue;
                    this.cqueryIterator.close();
                }
                catch (HomomorphismException e) {
                    throw new IteratorException("Exception during querying following subQuery: " + ecq, e);
                }
            }
        }
        if (this.tmpIt == null) return false;
        if (!this.tmpIt.hasNext()) return false;
        return true;
    }

    @Override
    public Substitution next() throws IteratorException {
        if (!this.hasNextCallDone) {
            this.hasNext();
        }
        this.hasNextCallDone = false;
        return this.tmpIt.next();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public void close() {
        if (this.tmpIt != null) {
            this.tmpIt.close();
        }
        if (this.cqueryIterator != null) {
            this.cqueryIterator.close();
        }
    }
}

