/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bbc;

import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.bbc.BCC;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import java.util.Arrays;

class BCCBackJumping
extends AbstractProfilable
implements BackJumping {
    private final BCC BCC;
    private BackJumping bj;
    boolean[] success;

    BCCBackJumping(BCC bcc, BackJumping bc) {
        this.BCC = bcc;
        this.bj = bc;
    }

    @Override
    public void init(VarSharedData[] vars) {
        this.bj.init(vars);
        this.success = new boolean[vars.length];
        Arrays.fill(this.success, false);
    }

    @Override
    public void clear() {
        this.bj.clear();
        Arrays.fill(this.success, false);
    }

    @Override
    public int previousLevel(VarSharedData var, Var[] vars) {
        int ret = this.bj.previousLevel(var, vars);
        if (this.BCC.varData[var.level].isEntry && !this.success[this.BCC.varData[var.level].previousLevelFailure]) {
            if (this.BCC.varData[this.BCC.varData[var.level].previousLevelFailure].forbidden != null) {
                this.BCC.varData[this.BCC.varData[var.level].previousLevelFailure].forbidden.add(vars[this.BCC.varData[var.level].previousLevelFailure].image);
            }
            this.getProfiler().incr("#BCCBackjumps", 1);
            ret = this.BCC.varData[var.level].previousLevelFailure;
        }
        return ret;
    }

    @Override
    public void addNeighborhoodToBackjumpSet(VarSharedData from, VarSharedData to) {
        this.bj.addNeighborhoodToBackjumpSet(from, to);
    }

    @Override
    public StringBuilder append(StringBuilder sb, int level) {
        return this.bj.append(sb, level);
    }

    @Override
    public void success() {
        this.bj.success();
        Arrays.fill(this.success, true);
    }

    @Override
    public void level(int level) {
        this.bj.level(level);
        this.success[level] = false;
    }
}

