/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bbc;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.store.Store;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.bbc.BCC;
import fr.lirmm.graphik.integraal.homomorphism.bbc.IntegerComparator;
import fr.lirmm.graphik.integraal.homomorphism.bbc.VarData;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.AbstractScheduler;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import fr.lirmm.graphik.integraal.homomorphism.utils.ProbaUtils;
import fr.lirmm.graphik.util.graph.DefaultDirectedEdge;
import fr.lirmm.graphik.util.graph.DefaultGraph;
import fr.lirmm.graphik.util.graph.DefaultHyperEdge;
import fr.lirmm.graphik.util.graph.DefaultHyperGraph;
import fr.lirmm.graphik.util.graph.DirectedEdge;
import fr.lirmm.graphik.util.graph.Graph;
import fr.lirmm.graphik.util.graph.HyperGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.mutable.MutableInt;

class BCCScheduler
extends AbstractScheduler
implements Scheduler {
    protected final BCC BCC;
    private Comparator<Integer> varComparator;
    private Term[] inverseMap;
    boolean withForbiddenCandidate;
    private double ansVariableFactor = 1.0E-4;

    BCCScheduler(BCC BCC2, boolean withForbiddenCandidate) {
        this.BCC = BCC2;
        this.withForbiddenCandidate = withForbiddenCandidate;
    }

    BCCScheduler(BCC BCC2, boolean withForbiddenCandidate, double ansVariableFactor) {
        this.BCC = BCC2;
        this.withForbiddenCandidate = withForbiddenCandidate;
        if (ansVariableFactor > 0.0 && ansVariableFactor <= 1.0) {
            this.ansVariableFactor = ansVariableFactor;
        }
    }

    @Override
    public VarSharedData[] execute(InMemoryAtomSet query, Set<Variable> preAffectedVars, List<Term> ans, AtomSet data, RulesCompilation rc) {
        double[] proba;
        InMemoryAtomSet fixedQuery = preAffectedVars.isEmpty() ? query : BCCScheduler.computeFixedQuery(query, preAffectedVars);
        Set<Variable> variables = fixedQuery.getVariables();
        HashMap<Term, Integer> map = new HashMap<Term, Integer>();
        this.inverseMap = new Term[variables.size() + 1];
        int i = 0;
        for (Variable variable : variables) {
            this.inverseMap[++i] = variable;
            map.put(variable, i);
        }
        HyperGraph graph = BCCScheduler.constructHyperGraph(fixedQuery, variables.size(), this.inverseMap, map, ans);
        if (data instanceof Store) {
            proba = this.computeProba(fixedQuery, (Store)data, variables.size(), map, rc);
        } else {
            proba = new double[variables.size() + 1];
            Arrays.fill(proba, 1.0);
        }
        for (Term t : ans) {
            int idx;
            if (!variables.contains(t)) continue;
            int n = idx = ((Integer)map.get(t)).intValue();
            proba[n] = proba[n] * this.ansVariableFactor;
        }
        this.varComparator = new IntegerComparator(proba);
        TmpData tmpData = BCCScheduler.biconnect(graph, this.varComparator);
        VarSharedData[] vars = new VarSharedData[variables.size() + 2];
        this.BCC.varData = new VarData[variables.size() + 2];
        vars[0] = new VarSharedData(0);
        this.BCC.varData[0] = new VarData();
        int lastAnswerVariable = -1;
        for (int i2 = 1; i2 < tmpData.vars.length; ++i2) {
            VarSharedData v;
            vars[v.level] = v = tmpData.vars[i2];
            this.BCC.varData[v.level] = tmpData.ext[i2];
            v.value = (Variable)this.inverseMap[i2];
            v.nextLevel = v.level + 1;
            v.previousLevel = v.level - 1;
            if (this.withForbiddenCandidate && this.BCC.varData[v.level].isAccesseur) {
                this.BCC.varData[v.level].forbidden = new HashSet<Term>();
            }
            if (!ans.contains(v.value) || v.level <= lastAnswerVariable) continue;
            lastAnswerVariable = v.level;
        }
        int level = variables.size() + 1;
        vars[level] = new VarSharedData(level);
        this.BCC.varData[level] = new VarData();
        vars[level].previousLevel = lastAnswerVariable;
        if (this.getProfiler().isProfilingEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (VarSharedData v : vars) {
                sb.append(v.value);
                sb.append(" > ");
            }
            this.getProfiler().put("BCCOrder", sb.toString());
        }
        return vars;
    }

    @Override
    public void clear() {
        for (VarData d : this.BCC.varData) {
            d.clear();
        }
    }

    @Override
    public boolean isAllowed(Var var, Term image) {
        return this.BCC.varData[var.shared.level].forbidden == null || !this.BCC.varData[var.shared.level].forbidden.contains(image);
    }

    protected double[] computeProba(InMemoryAtomSet h, Store data, int nbVar, Map<Term, Integer> map, RulesCompilation rc) {
        double[] proba = new double[nbVar + 1];
        Arrays.fill(proba, -1.0);
        for (Atom a : h) {
            double probaA = ProbaUtils.computeProba(a, data, rc);
            for (Term term : a.getVariables()) {
                int i = map.get(term);
                if (proba[i] < 0.0) {
                    proba[i] = probaA;
                    continue;
                }
                int n = i;
                proba[n] = proba[n] * probaA;
            }
        }
        return proba;
    }

    protected static TmpData biconnect(HyperGraph g, Comparator<Integer> varComparator) {
        TmpData d = new TmpData(g.nbVertices());
        d.components = new ArrayList<Set<Integer>>();
        d.i = 0;
        d.stack = new LinkedList<DirectedEdge>();
        d.lowpt = new int[g.nbVertices()];
        LinkedList<Integer> vertices = new LinkedList<Integer>();
        for (int v = 1; v < g.nbVertices(); ++v) {
            vertices.add(v);
        }
        Collections.sort(vertices, varComparator);
        for (Integer v : vertices) {
            if (d.vars[v.intValue()].level != 0) continue;
            BCCScheduler.biconnect(g, d, v, 0, varComparator);
        }
        return d;
    }

    protected static void biconnect(HyperGraph g, TmpData d, int v, int u, Comparator<Integer> varComparator) {
        LinkedList<Integer> lastAccesseurs = new LinkedList<Integer>();
        MutableInt lastTerminal = new MutableInt(0);
        BCCScheduler.biconnect(g, d, v, u, varComparator, lastAccesseurs, lastTerminal);
    }

    protected static void biconnect(HyperGraph g, TmpData d, int v, int u, Comparator<Integer> varComparator, Deque<Integer> lastAccesseurs, MutableInt lastTerminal) {
        d.vars[v].level = ++d.i;
        d.lowpt[v] = d.i;
        d.ext[v].previousLevelFailure = d.vars[u].level;
        Iterator<Integer> adjacencyIt = g.adjacencyList(v);
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (adjacencyIt.hasNext()) {
            list.add(adjacencyIt.next());
        }
        Collections.sort(list, varComparator);
        for (int w : list) {
            if (d.vars[w].level == 0) {
                DirectedEdge e;
                d.stack.push(new DefaultDirectedEdge(v, w));
                BCCScheduler.biconnect(g, d, w, v, varComparator);
                d.lowpt[v] = Math.min(d.lowpt[v], d.lowpt[w]);
                if (d.lowpt[w] < d.vars[v].level) continue;
                d.currentComponent = new HashSet<Integer>();
                d.components.add(d.currentComponent);
                while (d.vars[d.stack.peek().getTail()].level >= d.vars[w].level) {
                    e = d.stack.pop();
                    d.currentComponent.add(e.getTail());
                    d.currentComponent.add(e.getHead());
                }
                e = d.stack.pop();
                d.currentComponent.add(e.getTail());
                d.currentComponent.add(e.getHead());
                int entry = w;
                int accesseur = u == 0 ? u : v;
                int terminal = v;
                d.ext[accesseur].isAccesseur = true;
                for (int i : d.currentComponent) {
                    if ((u == 0 || i != v) && d.vars[i].level < d.vars[entry].level) {
                        entry = i;
                    }
                    if (d.vars[i].level > d.vars[terminal].level) {
                        terminal = i;
                    }
                    if (i == v) continue;
                    d.ext[i].accesseur = d.vars[accesseur].level;
                }
                d.ext[entry].isEntry = true;
                int componentVertice = d.bccGraph.addComponent(d.currentComponent);
                int accesseurVertice = d.bccGraph.addAccesseur(accesseur);
                d.bccGraph.addEdge(componentVertice, accesseurVertice);
                if (!lastAccesseurs.isEmpty() && d.vars[lastAccesseurs.peek().intValue()].level >= d.vars[entry].level) {
                    while (!lastAccesseurs.isEmpty() && d.vars[lastAccesseurs.peek().intValue()].level >= d.vars[entry].level) {
                        int a = lastAccesseurs.pop();
                        if (a == accesseur) continue;
                        d.bccGraph.addEdge(componentVertice, d.bccGraph.addAccesseur(a));
                    }
                } else {
                    d.ext[terminal].isTerminal = true;
                    d.ext[terminal].compilateurs = new TreeSet<Integer>();
                    lastTerminal.setValue(terminal);
                }
                d.ext[lastTerminal.getValue().intValue()].compilateurs.add(d.vars[entry].level);
                if (!lastAccesseurs.isEmpty() && lastAccesseurs.peek() == accesseur) continue;
                lastAccesseurs.push(accesseur);
                continue;
            }
            if (d.vars[w].level >= d.vars[v].level || w == u) continue;
            d.stack.push(new DefaultDirectedEdge(v, w));
            d.lowpt[v] = Math.min(d.lowpt[v], d.vars[w].level);
        }
    }

    protected static HyperGraph constructHyperGraph(InMemoryAtomSet h, int nbVariables, Term[] inverseMap, Map<Term, Integer> map, Iterable<Term> ans) {
        DefaultHyperGraph graph = new DefaultHyperGraph(nbVariables + 1);
        for (Atom a : h) {
            DefaultHyperEdge edge = new DefaultHyperEdge();
            int arity = 0;
            for (Variable t : a.getVariables()) {
                ++arity;
                edge.addVertice(map.get(t));
            }
            if (arity < 2) continue;
            graph.add(edge);
        }
        return graph;
    }

    @Override
    public String getInfos(Var var) {
        return this.BCC.varData[var.shared.level].toString();
    }

    protected static class TmpData {
        VarSharedData[] vars;
        VarData[] ext;
        int i;
        int[] lowpt;
        Deque<DirectedEdge> stack;
        List<Set<Integer>> components;
        Set<Integer> currentComponent;
        BCCGraph bccGraph = new BCCGraph();

        TmpData(int nbVertices) {
            this.vars = new VarSharedData[nbVertices];
            this.ext = new VarData[nbVertices];
            for (int i = 0; i < nbVertices; ++i) {
                this.vars[i] = new VarSharedData();
                this.ext[i] = new VarData();
            }
        }
    }

    protected static class BCCGraph {
        public Graph graph = new DefaultGraph();
        private List<Object> bccGraphMap = new ArrayList<Object>();
        public Map<Integer, Integer> bccGraphAccesseurInverseMap = new HashMap<Integer, Integer>();

        BCCGraph() {
        }

        int addAccesseur(int accesseur) {
            Integer v = this.bccGraphAccesseurInverseMap.get(accesseur);
            if (v == null) {
                v = this.graph.addVertex();
                this.bccGraphMap.add(accesseur);
                this.bccGraphAccesseurInverseMap.put(accesseur, v);
            }
            return v;
        }

        int addComponent(Set<Integer> component) {
            int v = this.graph.addVertex();
            this.bccGraphMap.add(component);
            return v;
        }

        Object getObject(int v) {
            return this.bccGraphMap.get(v);
        }

        void addEdge(int v1, int v2) {
            this.graph.addEdge(v1, v2);
        }

        public int nbVertices() {
            return this.graph.nbVertices();
        }

        public Iterator<Integer> adjacencyList(int v) {
            return this.graph.adjacencyList(v);
        }

        void printBccGraph(BCCGraph bccGraph, Term[] inverseMap) {
            System.out.println("\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            for (int i = 0; i < bccGraph.nbVertices(); ++i) {
                Iterator<Integer> adjacencyList = bccGraph.adjacencyList(i);
                this.printBccVertice(bccGraph, inverseMap, i);
                System.out.print(": ");
                while (adjacencyList.hasNext()) {
                    int j = adjacencyList.next();
                    this.printBccVertice(bccGraph, inverseMap, j);
                    System.out.print(" ");
                }
                System.out.println();
            }
            System.out.println("\n%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }

        void printBccVertice(BCCGraph g, Term[] inverseMap, int v) {
            Object o = g.getObject(v);
            if (o instanceof Integer) {
                System.out.print("(" + inverseMap[(Integer)o] + ")");
            } else if (o instanceof Set) {
                Set set = (Set)o;
                System.out.print("{");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int j = (Integer)iterator.next();
                    System.out.print(inverseMap[j] + " ");
                }
                System.out.print("}");
            }
        }
    }
}

