/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.bootstrapper;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.Bootstrapper;
import fr.lirmm.graphik.integraal.homomorphism.bootstrapper.BootstrapperUtils;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;

public class StarBootstrapper
extends AbstractProfilable
implements Bootstrapper {
    private static StarBootstrapper instance;

    protected StarBootstrapper() {
    }

    public static synchronized StarBootstrapper instance() {
        if (instance == null) {
            instance = new StarBootstrapper();
        }
        return instance;
    }

    @Override
    public CloseableIterator<Term> exec(VarSharedData v, Collection<Atom> preAtoms, Collection<Atom> postAtoms, AtomSet data, RulesCompilation compilation) throws BacktrackException {
        Set<Object> terms = null;
        if (this.getProfiler() != null) {
            this.getProfiler().start("BootstrapTime");
            this.getProfiler().start("BootstrapTimeFirstPart");
        }
        Set<Constant> constants = null;
        Atom aa = null;
        for (Atom atom : postAtoms) {
            if (constants != null && !constants.isEmpty()) continue;
            constants = atom.getConstants();
            aa = atom;
        }
        for (Atom atom : preAtoms) {
            if (constants != null && !constants.isEmpty()) continue;
            constants = atom.getConstants();
            aa = atom;
        }
        try {
            if (constants != null && !constants.isEmpty()) {
                terms = new TreeSet();
                for (Pair<Atom, Substitution> pair : compilation.getRewritingOf(aa)) {
                    int pos = ((Atom)pair.getLeft()).indexOf(((Substitution)pair.getRight()).createImageOf(v.value));
                    CloseableIterator<Atom> match = data.match((Atom)pair.getLeft());
                    while (match.hasNext()) {
                        terms.add(match.next().getTerm(pos));
                    }
                }
            }
            if (this.getProfiler() != null) {
                this.getProfiler().stop("BootstrapTimeFirstPart");
            }
            if (terms == null) {
                Iterator<Atom> it = postAtoms.iterator();
                while (it.hasNext()) {
                    if (terms == null) {
                        terms = BootstrapperUtils.computeCandidatesOverRewritings(it.next(), v, data, compilation);
                        continue;
                    }
                    terms.retainAll(BootstrapperUtils.computeCandidatesOverRewritings(it.next(), v, data, compilation));
                }
                it = preAtoms.iterator();
                while (it.hasNext()) {
                    if (terms == null) {
                        terms = BootstrapperUtils.computeCandidatesOverRewritings(it.next(), v, data, compilation);
                        continue;
                    }
                    terms.retainAll(BootstrapperUtils.computeCandidatesOverRewritings(it.next(), v, data, compilation));
                }
            }
            if (this.getProfiler() != null) {
                this.getProfiler().stop("BootstrapTime");
            }
            if (terms == null) {
                return data.termsIterator();
            }
            return new CloseableIteratorAdapter<Term>(terms.iterator());
        }
        catch (AtomSetException atomSetException) {
            throw new BacktrackException(atomSetException);
        }
        catch (IteratorException iteratorException) {
            throw new BacktrackException(iteratorException);
        }
    }
}

