/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.forward_checking;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.utils.BacktrackUtils;
import fr.lirmm.graphik.integraal.homomorphism.utils.HomomorphismIteratorChecker;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstractNFC
extends AbstractProfilable
implements ForwardChecking {
    protected VarData[] data;
    protected BackJumping bj;

    @Override
    public void setBackJumping(BackJumping bj) {
        this.bj = bj;
    }

    @Override
    public void init(VarSharedData[] vars, Map<Variable, Integer> map) {
        this.data = new VarData[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.data[vars[i].level] = new VarData();
            this.data[vars[i].level].candidats = new AcceptableCandidats[vars.length];
            this.data[vars[i].level].tmp = new HashSet<Term>();
            this.data[vars[i].level].toCheckAfterAssignment = new LinkedList<Atom>();
            for (Atom a : vars[i].preAtoms) {
                int cpt = 0;
                boolean toAdd = true;
                for (Variable t : a.getVariables()) {
                    if (!map.containsKey(t)) continue;
                    if (t.equals(vars[i].value)) {
                        ++cpt;
                        continue;
                    }
                    toAdd = false;
                }
                if (!toAdd && cpt <= true) continue;
                this.data[vars[i].level].toCheckAfterAssignment.add(a);
            }
            AcceptableCandidats previous = new AcceptableCandidats();
            for (VarSharedData z : vars[i].preVars) {
                AcceptableCandidats ac = new AcceptableCandidats();
                ac.candidats = new TreeSet<Term>();
                ac.previous = previous;
                previous = ac;
                this.data[vars[i].level].candidats[z.level] = ac;
            }
            this.data[vars[i].level].last = previous;
        }
    }

    @Override
    public void clear() {
        for (VarData d : this.data) {
            d.clear();
        }
    }

    @Override
    public boolean isInit(int level) {
        return this.data[level].last.init;
    }

    @Override
    public CloseableIterator<Term> getCandidatsIterator(AtomSet g, Var var, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws BacktrackException {
        HomomorphismIteratorChecker tmp;
        if (this.data[var.shared.level].last.init.booleanValue()) {
            tmp = new HomomorphismIteratorChecker(var, new CloseableIteratorAdapter<Term>(this.data[var.shared.level].last.candidats.iterator()), this.data[var.shared.level].toCheckAfterAssignment, g, initialSubstitution, map, varData, rc);
        } else {
            try {
                tmp = new HomomorphismIteratorChecker(var, g.termsIterator(), var.shared.preAtoms, g, initialSubstitution, map, varData, rc);
            }
            catch (AtomSetException e) {
                throw new BacktrackException(e);
            }
        }
        tmp.setProfiler(this.getProfiler());
        return tmp;
    }

    protected boolean check(Atom atom, VarSharedData currentVar, VarSharedData varToCompute, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws AtomSetException {
        Substitution s = BacktrackUtils.createSubstitution(varData);
        s.put(initialSubstitution);
        Atom im = s.createImageOf(atom);
        this.data[varToCompute.level].tmp.clear();
        Set<Term> candidats = this.data[varToCompute.level].candidats[currentVar.level].candidats;
        for (Pair<Atom, Substitution> rew : rc.getRewritingOf(im)) {
            Atom a = (Atom)rew.getLeft();
            for (Term t : candidats) {
                Atom fullInstantiatedAtom = Substitutions.createImageOf(a, varToCompute.value, t);
                Profiler profiler = this.getProfiler();
                if (profiler != null) {
                    profiler.incr("#check", 1);
                    profiler.start("checkTime");
                }
                if (g.contains(fullInstantiatedAtom)) {
                    this.data[varToCompute.level].tmp.add(t);
                }
                if (profiler == null) continue;
                profiler.stop("checkTime");
            }
        }
        candidats.retainAll(this.data[varToCompute.level].tmp);
        this.data[varToCompute.level].tmp.clear();
        if (candidats.isEmpty()) {
            this.bj.addNeighborhoodToBackjumpSet(varToCompute, currentVar);
            return false;
        }
        return true;
    }

    protected boolean select(Atom atom, Var v, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws AtomSetException, IteratorException {
        boolean contains = false;
        HashSet<Var> postVarsFromThisAtom = new HashSet<Var>();
        for (Pair<Atom, Substitution> pair : rc.getRewritingOf(atom)) {
            Atom a = (Atom)pair.getLeft();
            Var[] postV = this.computePostVariablesPosition(a, v.shared.level, map, varData, postVarsFromThisAtom);
            Substitution newInitialSubstitution = BacktrackUtils.createSubstitution(initialSubstitution, varData);
            Profiler profiler = this.getProfiler();
            if (profiler != null) {
                profiler.incr("#Select", 1);
                profiler.start("SelectTime");
            }
            int nbAns = 0;
            CloseableIterator<Atom> it = g.match(a, newInitialSubstitution);
            while (it.hasNext()) {
                ++nbAns;
                int i = -1;
                for (Term t : it.next()) {
                    if (postV[++i] == null) continue;
                    this.data[postV[i].shared.level].tmp.add(t);
                }
                contains = true;
            }
            if (profiler == null) continue;
            profiler.stop("SelectTime");
            profiler.incr("#SelectAns", nbAns);
        }
        boolean isThereAnEmptiedList = false;
        if (contains) {
            for (Var z : postVarsFromThisAtom) {
                if (!isThereAnEmptiedList) {
                    AcceptableCandidats ac = this.data[z.shared.level].candidats[v.shared.level];
                    if (ac.init.booleanValue()) {
                        ac.candidats.retainAll(this.data[z.shared.level].tmp);
                        isThereAnEmptiedList |= ac.candidats.isEmpty();
                        if (ac.candidats.isEmpty()) {
                            this.bj.addNeighborhoodToBackjumpSet(z.shared, v.shared);
                        }
                    } else {
                        ac.candidats.addAll(this.data[z.shared.level].tmp);
                        ac.init = true;
                    }
                }
                this.data[z.shared.level].tmp.clear();
            }
        } else {
            Var var = (Var)postVarsFromThisAtom.iterator().next();
            this.bj.addNeighborhoodToBackjumpSet(var.shared, v.shared);
        }
        return contains && !isThereAnEmptiedList;
    }

    protected Var[] computePostVariablesPosition(Atom atom, int level, Map<Variable, Integer> map, Var[] varData, Set<Var> postVars) {
        Var[] postV = new Var[atom.getPredicate().getArity()];
        int i = -1;
        for (Term t : atom) {
            ++i;
            Integer idx = map.get(t);
            if (idx == null) continue;
            Var z = varData[idx];
            if (z.shared.level <= level) continue;
            postV[i] = z;
            postVars.add(z);
        }
        return postV;
    }

    protected void clear(VarSharedData v, VarSharedData z) {
        AcceptableCandidats ac = this.data[z.level].candidats[v.level];
        ac.candidats.clear();
        ac.init = false;
        if (ac.previous.init.booleanValue()) {
            ac.candidats.addAll(ac.previous.candidats);
            ac.init = true;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int level = 0; level < this.data.length; ++level) {
            sb.append(level + ": ");
            this.append(sb, level);
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public StringBuilder append(StringBuilder sb, int level) {
        for (int i = 1; i < level; ++i) {
            if (this.data[level].candidats[i] == null) continue;
            sb.append(i + "=" + this.data[level].candidats[i] + ", ");
        }
        return sb;
    }

    protected class VarData {
        AcceptableCandidats[] candidats;
        AcceptableCandidats last;
        Set<Term> tmp;
        Collection<Atom> toCheckAfterAssignment;

        protected VarData() {
        }

        public void clear() {
            this.tmp.clear();
            for (AcceptableCandidats ac : this.candidats) {
                if (ac == null) continue;
                ac.candidats.clear();
                ac.init = false;
            }
        }
    }

    protected class AcceptableCandidats {
        Set<Term> candidats;
        AcceptableCandidats previous;
        Boolean init = false;

        protected AcceptableCandidats() {
        }

        public String toString() {
            if (this.init.booleanValue()) {
                return this.candidats.toString();
            }
            return "";
        }
    }
}

