/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.forward_checking;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.AbstractNFC;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.NFC2;
import fr.lirmm.graphik.integraal.homomorphism.utils.BacktrackUtils;
import fr.lirmm.graphik.integraal.homomorphism.utils.HomomorphismIteratorChecker;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class NFC2WithLimit
extends NFC2
implements ForwardChecking {
    protected VarDataWithLimit[] dataWithLimit;
    private final int LIMIT;

    public NFC2WithLimit(int limit) {
        super(false);
        this.LIMIT = limit;
    }

    public NFC2WithLimit(int limit, boolean enableCheckMode) {
        super(enableCheckMode);
        this.LIMIT = limit;
    }

    @Override
    public void init(VarSharedData[] vars, Map<Variable, Integer> map) {
        super.init(vars, map);
        this.dataWithLimit = new VarDataWithLimit[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.dataWithLimit[vars[i].level] = new VarDataWithLimit();
            this.dataWithLimit[vars[i].level].atomsToCheck = new HashSet<Atom>();
        }
    }

    @Override
    public CloseableIterator<Term> getCandidatsIterator(AtomSet g, Var var, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws BacktrackException {
        HomomorphismIteratorChecker tmp;
        if (this.data[var.shared.level].last.init.booleanValue()) {
            this.dataWithLimit[var.shared.level].atomsToCheck.addAll(this.data[var.shared.level].toCheckAfterAssignment);
            tmp = new HomomorphismIteratorChecker(var, new CloseableIteratorAdapter<Term>(this.data[var.shared.level].last.candidats.iterator()), this.dataWithLimit[var.shared.level].atomsToCheck, g, initialSubstitution, map, varData, rc);
        } else {
            try {
                tmp = new HomomorphismIteratorChecker(var, g.termsIterator(), var.shared.preAtoms, g, initialSubstitution, map, varData, rc);
            }
            catch (AtomSetException e) {
                throw new BacktrackException(e);
            }
        }
        tmp.setProfiler(this.getProfiler());
        return tmp;
    }

    @Override
    protected boolean select(Atom atom, Var v, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws AtomSetException, IteratorException {
        boolean contains = false;
        int nbAns = 0;
        Iterator<Pair<Atom, Substitution>> rewIt = rc.getRewritingOf(atom).iterator();
        HashSet<Var> postVarsFromThisAtom = new HashSet<Var>();
        while (rewIt.hasNext() && nbAns < this.LIMIT) {
            Atom a = (Atom)rewIt.next().getLeft();
            Var[] postV = this.computePostVariablesPosition(a, v.shared.level, map, varData, postVarsFromThisAtom);
            Substitution newInitialSubstitution = BacktrackUtils.createSubstitution(initialSubstitution, varData);
            Profiler profiler = this.getProfiler();
            if (profiler != null) {
                profiler.incr("#Select", 1);
                profiler.start("SelectTime");
            }
            int cpt = 0;
            CloseableIterator<Atom> it = g.match(a, newInitialSubstitution);
            while (it.hasNext() && nbAns < this.LIMIT) {
                ++nbAns;
                ++cpt;
                int i = -1;
                for (Term t : it.next()) {
                    if (postV[++i] == null) continue;
                    this.data[postV[i].shared.level].tmp.add(t);
                }
                contains = true;
            }
            if (profiler == null) continue;
            profiler.stop("SelectTime");
            profiler.incr("#SelectAns", cpt);
        }
        boolean isThereAnEmptiedList = false;
        if (contains) {
            for (Var z : postVarsFromThisAtom) {
                if (!isThereAnEmptiedList) {
                    if (nbAns >= this.LIMIT) {
                        this.dataWithLimit[z.shared.level].atomsToCheck.add(atom);
                    } else {
                        AbstractNFC.AcceptableCandidats ac = this.data[z.shared.level].candidats[v.shared.level];
                        if (ac.init.booleanValue()) {
                            ac.candidats.retainAll(this.data[z.shared.level].tmp);
                            isThereAnEmptiedList |= ac.candidats.isEmpty();
                            if (ac.candidats.isEmpty()) {
                                this.bj.addNeighborhoodToBackjumpSet(z.shared, v.shared);
                            }
                        } else {
                            ac.candidats.addAll(this.data[z.shared.level].tmp);
                            ac.init = true;
                        }
                    }
                }
                this.data[z.shared.level].tmp.clear();
            }
        } else {
            Var z = (Var)postVarsFromThisAtom.iterator().next();
            this.bj.addNeighborhoodToBackjumpSet(z.shared, v.shared);
        }
        return contains && !isThereAnEmptiedList;
    }

    @Override
    protected void clear(VarSharedData v, VarSharedData z) {
        super.clear(v, z);
        this.dataWithLimit[z.level].atomsToCheck.removeAll(v.postAtoms);
    }

    protected class VarDataWithLimit {
        Collection<Atom> atomsToCheck;

        protected VarDataWithLimit() {
        }
    }
}

