/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.forward_checking;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.homomorphism.BacktrackException;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.backjumping.BackJumping;
import fr.lirmm.graphik.integraal.homomorphism.forward_checking.ForwardChecking;
import fr.lirmm.graphik.integraal.homomorphism.utils.BacktrackUtils;
import fr.lirmm.graphik.integraal.homomorphism.utils.HomomorphismIteratorChecker;
import fr.lirmm.graphik.util.profiler.AbstractProfilable;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleFC
extends AbstractProfilable
implements ForwardChecking {
    @Override
    public void init(VarSharedData[] vars, Map<Variable, Integer> map) {
    }

    @Override
    public boolean checkForward(Var v, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws BacktrackException {
        Profiler profiler = this.getProfiler();
        for (Atom atom : v.shared.postAtoms) {
            boolean contains = false;
            Substitution newInitialSubstitution = BacktrackUtils.createSubstitution(initialSubstitution, varData);
            if (profiler != null) {
                profiler.incr("#selectOne", 1);
                profiler.start("selectOneTime");
            }
            for (Pair<Atom, Substitution> rew : rc.getRewritingOf(atom)) {
                Atom a = (Atom)rew.getLeft();
                CloseableIterator<Atom> matchIt = null;
                try {
                    matchIt = g.match(a, newInitialSubstitution);
                    if (!matchIt.hasNext()) continue;
                    contains = true;
                    break;
                }
                catch (IteratorException e) {
                    throw new BacktrackException(e);
                }
                catch (AtomSetException e) {
                    throw new BacktrackException(e);
                }
                finally {
                    if (matchIt == null) continue;
                    matchIt.close();
                }
            }
            if (profiler != null) {
                profiler.stop("selectOneTime");
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInit(int level) {
        return false;
    }

    @Override
    public CloseableIterator<Term> getCandidatsIterator(AtomSet g, Var var, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) throws BacktrackException {
        HomomorphismIteratorChecker tmp;
        try {
            tmp = new HomomorphismIteratorChecker(var, g.termsIterator(), var.shared.preAtoms, g, initialSubstitution, map, varData, rc);
        }
        catch (AtomSetException e) {
            throw new BacktrackException(e);
        }
        tmp.setProfiler(this.getProfiler());
        return tmp;
    }

    @Override
    public void setBackJumping(BackJumping bj) {
    }

    @Override
    public StringBuilder append(StringBuilder sb, int level) {
        return sb.append("SimpleFC");
    }

    @Override
    public void clear() {
    }
}

