/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.scheduler;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.VarSharedData;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.AbstractScheduler;
import fr.lirmm.graphik.integraal.homomorphism.scheduler.Scheduler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class FixedOrderScheduler
extends AbstractScheduler
implements Scheduler {
    private List<Variable> order;

    public FixedOrderScheduler(List<Variable> order) {
        this.order = order;
    }

    public FixedOrderScheduler(Variable ... order) {
        this.order = Arrays.asList(order);
    }

    @Override
    public VarSharedData[] execute(InMemoryAtomSet query, Set<Variable> preAffectedVars, List<Term> ans, AtomSet data, RulesCompilation rc) throws HomomorphismException {
        InMemoryAtomSet h = preAffectedVars.isEmpty() ? query : FixedOrderScheduler.computeFixedQuery(query, preAffectedVars);
        Set<Variable> terms = h.getVariables();
        VarSharedData[] vars = new VarSharedData[terms.size() + 2];
        int level = 0;
        vars[level] = new VarSharedData(level);
        TreeSet<Variable> alreadyAffected = new TreeSet<Variable>();
        for (Variable v : this.order) {
            if (!terms.contains(v)) {
                throw new HomomorphismException("Try to schedule a variable which is not in the query :" + v);
            }
            if (alreadyAffected.contains(v)) {
                throw new HomomorphismException("There is two occurences of the same variable in the specified order.");
            }
            vars[++level] = new VarSharedData(level);
            vars[level].value = v;
            alreadyAffected.add(v);
        }
        terms.removeAll(alreadyAffected);
        if (!terms.isEmpty()) {
            throw new HomomorphismException("Some variables of the query are not scheduled :" + terms);
        }
        vars[++level] = new VarSharedData(level);
        vars[level].previousLevel = level - 1;
        return vars;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean isAllowed(Var var, Term image) {
        return true;
    }

    @Override
    public String getInfos(Var var) {
        return Integer.toString(this.order.indexOf(var.shared.value));
    }
}

