/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.utils;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.TreeMapSubstitution;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class BacktrackUtils {
    private BacktrackUtils() {
    }

    public static boolean isHomomorphism(Iterable<Atom> atomsFrom, AtomSet atomsTo, Substitution initialSubstitution, Map<Variable, Integer> index, Var[] varData, RulesCompilation rc) throws AtomSetException {
        for (Atom atom : atomsFrom) {
            Atom image = BacktrackUtils.createImageOf(atom, initialSubstitution, index, varData);
            boolean contains = false;
            for (Pair<Atom, Substitution> p : rc.getRewritingOf(image)) {
                if (!atomsTo.contains((Atom)p.getLeft())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            return false;
        }
        return true;
    }

    public static Atom createImageOf(Atom atom, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData) {
        Term[] termsSubstitut = new Term[atom.getPredicate().getArity()];
        int i = -1;
        for (Term term : atom) {
            if (term.isVariable()) {
                Term t = initialSubstitution.createImageOf(term);
                termsSubstitut[++i] = t.isVariable() ? BacktrackUtils.imageOf((Variable)t, map, varData) : t;
                continue;
            }
            termsSubstitut[++i] = term;
        }
        return new DefaultAtom(atom.getPredicate(), termsSubstitut);
    }

    public static Term imageOf(Variable var, Map<Variable, Integer> map, Var[] varData) {
        Term t;
        Integer i = map.get(var);
        if (i != null && (t = varData[i.intValue()].image) != null) {
            return t;
        }
        return var;
    }

    public static Substitution createSubstitution(Var[] vars) {
        TreeMapSubstitution s = new TreeMapSubstitution();
        for (Var v : vars) {
            if (v.image == null) continue;
            s.put(v.shared.value, v.image);
        }
        return s;
    }

    public static Substitution createSubstitution(Substitution initialSubstitution, Var[] vars) {
        TreeMapSubstitution s = new TreeMapSubstitution(initialSubstitution);
        for (Var v : vars) {
            if (v.image == null) continue;
            s.put(v.shared.value, v.image);
        }
        return s;
    }
}

