/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.utils;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.ConjunctiveQuery;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.Substitutions;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomSetFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultConjunctiveQueryFactory;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import java.util.LinkedList;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class EqualityUtils {
    private EqualityUtils() {
    }

    public static Pair<ConjunctiveQuery, Substitution> processEquality(ConjunctiveQuery q) {
        LinkedList<Atom> toRemove = new LinkedList<Atom>();
        Substitution s = DefaultSubstitutionFactory.instance().createSubstitution();
        for (Atom a : q.getAtomSet()) {
            if (!Predicate.EQUALITY.equals(a.getPredicate())) continue;
            if (a.getTerm(0).isVariable()) {
                if (!EqualityUtils.updateSubstitution(s, (Variable)a.getTerm(0), a.getTerm(1))) {
                    return EqualityUtils.generateBottomResult();
                }
                toRemove.add(a);
                continue;
            }
            if (a.getTerm(1).isVariable()) {
                if (!EqualityUtils.updateSubstitution(s, (Variable)a.getTerm(1), a.getTerm(0))) {
                    return EqualityUtils.generateBottomResult();
                }
                toRemove.add(a);
                continue;
            }
            return EqualityUtils.generateBottomResult();
        }
        return new ImmutablePair((Object)EqualityUtils.generateQuery(q, s, toRemove), (Object)s);
    }

    private static boolean updateSubstitution(Substitution s, Variable var, Term image) {
        return s.aggregate(var, image);
    }

    private static ConjunctiveQuery generateQuery(ConjunctiveQuery q, Substitution s, LinkedList<Atom> toRemove) {
        if (toRemove.isEmpty()) {
            return q;
        }
        LinkedList<Term> newAns = new LinkedList<Term>(q.getAnswerVariables());
        newAns.removeAll(s.getTerms());
        InMemoryAtomSet newAtomSet = DefaultAtomSetFactory.instance().create();
        for (Atom a : q.getAtomSet()) {
            if (toRemove.contains(a)) continue;
            newAtomSet.add(s.createImageOf(a));
        }
        return DefaultConjunctiveQueryFactory.instance().create(newAtomSet, newAns);
    }

    private static ImmutablePair<ConjunctiveQuery, Substitution> generateBottomResult() {
        return new ImmutablePair((Object)DefaultConjunctiveQueryFactory.instance().BOOLEAN_BOTTOM_QUERY, (Object)Substitutions.emptySubstitution());
    }
}

