/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.utils;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.AtomSetException;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.homomorphism.Var;
import fr.lirmm.graphik.integraal.homomorphism.utils.BacktrackUtils;
import fr.lirmm.graphik.util.profiler.Profilable;
import fr.lirmm.graphik.util.profiler.Profiler;
import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Map;

public class HomomorphismIteratorChecker
extends AbstractCloseableIterator<Term>
implements Profilable {
    private CloseableIterator<Term> it;
    private Term next;
    private Var var;
    private Iterable<Atom> h;
    private AtomSet g;
    private Map<Variable, Integer> map;
    private RulesCompilation rc;
    private Profiler profiler;
    private Substitution initialSubstitution;
    private Var[] varData;

    public HomomorphismIteratorChecker(Var var, CloseableIterator<Term> it, Iterable<Atom> h, AtomSet g, Substitution initialSubstitution, Map<Variable, Integer> map, Var[] varData, RulesCompilation rc) {
        this.var = var;
        this.it = it;
        this.h = h;
        this.g = g;
        this.map = map;
        this.varData = varData;
        this.rc = rc;
        this.initialSubstitution = initialSubstitution;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        try {
            while (this.next == null && this.it.hasNext()) {
                Term t = this.it.next();
                if (!this.check(t, this.varData)) continue;
                this.next = t;
            }
        }
        catch (AtomSetException e) {
            throw new IteratorException(e);
        }
        return this.next != null;
    }

    @Override
    public Term next() throws IteratorException {
        this.hasNext();
        Term t = this.next;
        this.next = null;
        return t;
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public void setProfiler(Profiler profiler) {
        this.profiler = profiler;
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    private boolean check(Term t, Var[] varData) throws AtomSetException {
        this.var.image = t;
        Profiler profiler = this.getProfiler();
        if (profiler != null) {
            profiler.incr("#isHomomorphism", 1);
            profiler.start("isHomomorphismTime");
        }
        boolean res = BacktrackUtils.isHomomorphism(this.h, this.g, this.initialSubstitution, this.map, varData, this.rc);
        if (profiler != null) {
            profiler.stop("isHomomorphismTime");
        }
        return res;
    }
}

