/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.homomorphism.utils;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.RulesCompilation;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.store.Store;
import org.apache.commons.lang3.tuple.Pair;

public final class ProbaUtils {
    private ProbaUtils() {
    }

    public static double computeProba(Atom atom, Store data, RulesCompilation rc) {
        double probaA;
        int count = 0;
        for (Pair<Atom, Substitution> im : rc.getRewritingOf(atom)) {
            count += data.size(((Atom)im.getLeft()).getPredicate());
        }
        if (count == 0) {
            probaA = 0.0;
        } else {
            int nbCst = 0;
            int nbVar = 0;
            for (Term t : atom) {
                if (t.isConstant()) {
                    ++nbCst;
                    continue;
                }
                ++nbVar;
            }
            int domSize = data.getDomainSize();
            probaA = (double)count / Math.pow(domSize, nbCst) / Math.pow(data.getDomainSize(), nbVar);
        }
        return probaA;
    }
}

