/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.rulesetanalyser.RuleSetPropertyHierarchy;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import fr.lirmm.graphik.util.graph.scc.StronglyConnectedComponentsGraph;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Analyser {
    public static final int COMBINE_NONE = 0;
    public static final int COMBINE_FES = 1;
    public static final int COMBINE_FUS = 2;
    public static final int COMBINE_BTS = 4;
    private AnalyserRuleSet ruleSet;
    private RuleSetPropertyHierarchy hierarchy = new RuleSetPropertyHierarchy();
    private List<Map<String, Integer>> sccProperties;
    private List<Map<String, Integer>> ruleProperties;
    private Map<String, Integer> ruleSetProperties;

    public Analyser() {
    }

    public Analyser(AnalyserRuleSet rules) {
        this();
        this.ruleSet = rules;
    }

    public void setRuleSet(AnalyserRuleSet rules) {
        this.ruleSet = rules;
    }

    public void setRuleSet(Iterable<Rule> rules) {
        this.ruleSet = new AnalyserRuleSet(rules);
    }

    public AnalyserRuleSet getRuleSet() {
        return this.ruleSet;
    }

    public void setProperties(RuleSetPropertyHierarchy h) {
        this.hierarchy = h;
    }

    public void setProperties(Iterable<RuleSetProperty> pties) {
        this.hierarchy = new RuleSetPropertyHierarchy(pties);
    }

    public boolean isDecidable() {
        for (int i : this.ruleSetProperties().values()) {
            if (i <= 0) continue;
            return true;
        }
        return this.combineFES() != null;
    }

    public boolean isFES() {
        int[] combine = this.combineFES();
        if (combine == null) {
            return false;
        }
        for (int i = 0; i < combine.length; ++i) {
            if ((combine[i] & 1) != 0) continue;
            return false;
        }
        return true;
    }

    public boolean isFUS() {
        int[] combine = this.combineFUS();
        if (combine == null) {
            return false;
        }
        for (int i = 0; i < combine.length; ++i) {
            if ((combine[i] & 2) != 0) continue;
            return false;
        }
        return true;
    }

    public Map<String, Integer> ruleSetProperties() {
        if (this.ruleSetProperties == null) {
            this.ruleSetProperties = this.computeProperties(this.ruleSet);
        }
        return this.ruleSetProperties;
    }

    public List<Map<String, Integer>> sccProperties() {
        if (this.sccProperties == null) {
            this.sccProperties = new LinkedList<Map<String, Integer>>();
            for (AnalyserRuleSet subAnalyser : this.ruleSet.getSCC()) {
                this.sccProperties.add(this.computeProperties(subAnalyser));
            }
        }
        return this.sccProperties;
    }

    public List<Map<String, Integer>> ruleProperties() {
        if (this.ruleProperties == null) {
            this.ruleProperties = new LinkedList<Map<String, Integer>>();
            for (Rule r : this.ruleSet) {
                AnalyserRuleSet subAnalyser = new AnalyserRuleSet(r);
                this.ruleProperties.add(this.computeProperties(subAnalyser));
            }
        }
        return this.ruleProperties;
    }

    public int[] combineFES() {
        int n = this.ruleSet.getSCC().size();
        StronglyConnectedComponentsGraph<Rule> scc = this.ruleSet.getStronglyConnectedComponentsGraph();
        int[] layers = scc.computeLayers(scc.getSources(), true);
        boolean[] mark = new boolean[n];
        int[] result = this.prepareCombine();
        for (int i = 0; i < n; ++i) {
            mark[i] = false;
        }
        LinkedList<Integer> waiting = new LinkedList<Integer>();
        for (Integer s : scc.getSources()) {
            waiting.addLast(s);
            mark[s.intValue()] = true;
        }
        while (!waiting.isEmpty()) {
            int s = (Integer)waiting.pollFirst();
            if (result[s] == 0) {
                return null;
            }
            if ((result[s] & 1) != 0) {
                result[s] = 1;
            } else if ((result[s] & 2) != 0) {
                result[s] = 2;
            }
            Iterator iterator = scc.outgoingEdgesOf(s).iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                int succ = (Integer)scc.getEdgeTarget(t);
                if ((result[s] & 1) == 0) {
                    int n2 = succ;
                    result[n2] = result[n2] & 2;
                }
                if (mark[succ] || layers[s] + 1 != layers[succ]) continue;
                mark[succ] = true;
                waiting.addLast(succ);
            }
        }
        return result;
    }

    public int[] combineFUS() {
        int n = this.ruleSet.getSCC().size();
        StronglyConnectedComponentsGraph<Rule> scc = this.ruleSet.getStronglyConnectedComponentsGraph();
        int[] layers = scc.computeLayers(scc.getSinks(), false);
        boolean[] mark = new boolean[n];
        int[] result = this.prepareCombine();
        for (int i = 0; i < n; ++i) {
            mark[i] = false;
        }
        LinkedList<Integer> waiting = new LinkedList<Integer>();
        for (Integer s : scc.getSinks()) {
            waiting.addLast(s);
            mark[s.intValue()] = true;
        }
        while (!waiting.isEmpty()) {
            int s = (Integer)waiting.pollFirst();
            if (result[s] == 0) {
                return null;
            }
            if ((result[s] & 2) != 0) {
                result[s] = 2;
            } else if ((result[s] & 1) != 0) {
                result[s] = 1;
            }
            Iterator iterator = scc.incomingEdgesOf(s).iterator();
            while (iterator.hasNext()) {
                int t = (Integer)iterator.next();
                int succ = (Integer)scc.getEdgeSource(t);
                if ((result[s] & 2) == 0) {
                    int n2 = succ;
                    result[n2] = result[n2] & 1;
                }
                if (mark[succ] || layers[s] + 1 != layers[succ]) continue;
                mark[succ] = true;
                waiting.addLast(succ);
            }
        }
        return result;
    }

    protected int[] prepareCombine() {
        int n = this.ruleSet.getSCC().size();
        int[] result = new int[n];
        int i = 0;
        List<Map<String, Integer>> sccPties = this.sccProperties();
        for (Map<String, Integer> scc : sccPties) {
            result[i] = 0;
            if (scc.get(FESProperty.instance().getLabel()) != null && scc.get(FESProperty.instance().getLabel()) != 0) {
                int n2 = i;
                result[n2] = result[n2] | 1;
            }
            if (scc.get(FUSProperty.instance().getLabel()) != null && scc.get(FUSProperty.instance().getLabel()) != 0) {
                int n3 = i;
                result[n3] = result[n3] | 2;
            }
            if (scc.get(BTSProperty.instance().getLabel()) != null && scc.get(BTSProperty.instance().getLabel()) != 0) {
                int n4 = i;
                result[n4] = result[n4] | 4;
            }
            ++i;
        }
        return result;
    }

    protected Map<String, Integer> computeProperties(AnalyserRuleSet set) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        Iterable<RuleSetProperty> pties = this.hierarchy.getOrderedProperties();
        for (RuleSetProperty p : pties) {
            if (result.get(p.getLabel()) != null) continue;
            int res = p.check(set);
            result.put(p.getLabel(), res);
            if (res <= 0) continue;
            for (RuleSetProperty p2 : this.hierarchy.getGeneralisationsOf(p)) {
                result.put(p2.getLabel(), res);
            }
        }
        return result;
    }
}

