/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.PredicatePosition;
import java.util.Set;
import java.util.TreeSet;

class AbstractAffectedPositionSet {
    protected Iterable<Rule> ruleSet;
    protected Set<PredicatePosition> affectedPosition = new TreeSet<PredicatePosition>();

    public AbstractAffectedPositionSet(Iterable<Rule> ruleSet) {
        this.ruleSet = ruleSet;
        this.init();
    }

    public Iterable<Rule> getRules() {
        return this.ruleSet;
    }

    public boolean isAffected(Predicate predicate, int position) {
        PredicatePosition predicatePosition = new PredicatePosition(predicate, position);
        return this.isAffected(predicatePosition);
    }

    public boolean isAffected(PredicatePosition pp) {
        return this.affectedPosition.contains(pp);
    }

    public Set<Variable> getAllAffectedVariables(InMemoryAtomSet body) {
        TreeSet<Variable> set = new TreeSet<Variable>();
        for (Variable t : body.getVariables()) {
            set.add(t);
        }
        return this.getAllAffectedVariables(set, body);
    }

    public Set<Variable> getAllAffectedFrontierVariables(Rule rule) {
        return this.getAllAffectedVariables(rule.getFrontier(), rule.getBody());
    }

    protected void step2() {
    }

    protected Set<Variable> getAllAffectedVariables(Set<Variable> vars, InMemoryAtomSet body) {
        TreeSet<Variable> affectedVars = new TreeSet<Variable>();
        affectedVars.addAll(vars);
        for (Atom atom : body) {
            int i = -1;
            for (Term t : atom) {
                if (!t.isVariable() || this.isAffected(atom.getPredicate(), ++i)) continue;
                affectedVars.remove(t);
            }
        }
        return affectedVars;
    }

    protected void init() {
        this.step1();
        this.step2();
    }

    protected void step1() {
        for (Rule rule : this.ruleSet) {
            Set<Variable> existentials = rule.getExistentials();
            for (Atom atom : rule.getHead()) {
                int i = -1;
                for (Term t : atom) {
                    ++i;
                    if (!existentials.contains(t)) continue;
                    PredicatePosition predicatePosition = new PredicatePosition(atom.getPredicate(), i);
                    this.affectedPosition.add(predicatePosition);
                }
            }
        }
    }

    protected boolean affectInHead(Rule rule, Term term) {
        boolean addSomeAffectedPosition = false;
        for (Atom atom : rule.getHead()) {
            int i = -1;
            for (Term t : atom) {
                PredicatePosition predicatePosition;
                if (!term.equals(t) || this.isAffected(predicatePosition = new PredicatePosition(atom.getPredicate(), ++i))) continue;
                this.affectedPosition.add(predicatePosition);
                addSomeAffectedPosition = true;
            }
        }
        return addSomeAffectedPosition;
    }
}

