/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.graph;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.PredicatePosition;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;

public class MarkedVariableSet {
    private LinkedList<MarkedRule> markedRuleSet;
    private Map<Predicate, LinkedList<MarkedRule>> map;
    private Queue<PredicatePosition> markedPosition = new LinkedList<PredicatePosition>();

    public MarkedVariableSet(Iterable<Rule> rules) {
        this.markedRuleSet = new LinkedList();
        for (Rule r : rules) {
            this.markedRuleSet.add(new MarkedRule(r));
        }
        this.map = new HashMap<Predicate, LinkedList<MarkedRule>>();
        this.process();
    }

    public Collection<MarkedRule> getMarkedRuleCollection() {
        return this.markedRuleSet;
    }

    private void process() {
        this.firstStep();
        this.secondStep();
    }

    private void firstStep() {
        for (MarkedRule markedRule : this.markedRuleSet) {
            for (Atom atom : markedRule.rule.getHead()) {
                Predicate p = atom.getPredicate();
                LinkedList<MarkedRule> set = this.map.get(p);
                if (set == null) {
                    set = new LinkedList();
                    this.map.put(p, set);
                }
                set.add(markedRule);
            }
            this.testRule(markedRule);
        }
    }

    private void testRule(MarkedRule mrule) {
        Set<Variable> bodyVars = mrule.rule.getBody().getVariables();
        for (Term term : bodyVars) {
            for (Atom a : mrule.rule.getHead()) {
                if (a.getTerms().contains(term)) continue;
                this.mark(term, mrule);
            }
        }
    }

    private void mark(Term v, MarkedRule mrule) {
        if (!mrule.markedVars.contains(v)) {
            mrule.markedVars.add(v);
            for (Atom a : mrule.rule.getBody()) {
                int i = 0;
                for (Term t : a) {
                    if (v.equals(t)) {
                        this.markedPosition.add(new PredicatePosition(a.getPredicate(), i));
                    }
                    ++i;
                }
            }
        }
    }

    private void secondStep() {
        while (!this.markedPosition.isEmpty()) {
            PredicatePosition mpos = this.markedPosition.poll();
            LinkedList<MarkedRule> mrList = this.map.get(mpos.predicate);
            if (mrList == null) continue;
            for (MarkedRule mr : mrList) {
                for (Atom a : mr.rule.getHead()) {
                    Term v;
                    if (!a.getPredicate().equals(mpos.predicate) || !(v = a.getTerm(mpos.position)).isVariable()) continue;
                    this.mark(v, mr);
                }
            }
        }
    }

    public static class MarkedRule {
        public Rule rule;
        public Set<Term> markedVars;

        public MarkedRule(Rule rule) {
            this.rule = rule;
            this.markedVars = new TreeSet<Term>();
        }
    }
}

