/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.core.grd.DefaultGraphOfRuleDependencies;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;

public final class AGRDProperty
extends RuleSetProperty.Default {
    private static AGRDProperty instance = null;

    private AGRDProperty() {
    }

    public static synchronized AGRDProperty instance() {
        if (instance == null) {
            instance = new AGRDProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Acyclic graph of rule dependencies";
    }

    @Override
    public String getDescription() {
        return "The associated graph of rule dependencies does not contain any circuit.";
    }

    @Override
    public int check(AnalyserRuleSet ruleset) {
        DefaultGraphOfRuleDependencies g = ruleset.getGraphOfRuleDependencies();
        if (g.hasCircuit()) {
            return -1;
        }
        return 1;
    }

    @Override
    public String getLabel() {
        return "agrd";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(FESProperty.instance());
        gen.add(FUSProperty.instance());
        return gen;
    }
}

