/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.DomainRestrictedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FrontierGuardedProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyAcyclicProperty;
import java.util.LinkedList;

public final class DisconnectedProperty
extends RuleSetProperty.Local {
    private static DisconnectedProperty instance = null;

    private DisconnectedProperty() {
    }

    public static synchronized DisconnectedProperty instance() {
        if (instance == null) {
            instance = new DisconnectedProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Disconnected";
    }

    @Override
    public String getDescription() {
        return "The frontier is empty. Note that any disconnected rule needs to be applied only once.";
    }

    @Override
    public int check(Rule rule) {
        if (rule.getFrontier().isEmpty()) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "disc";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(WeaklyAcyclicProperty.instance());
        gen.add(FrontierGuardedProperty.instance());
        gen.add(DomainRestrictedProperty.instance());
        gen.add(FESProperty.instance());
        gen.add(FUSProperty.instance());
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

