/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FUSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import java.util.LinkedList;
import java.util.Set;

public class DomainRestrictedProperty
extends RuleSetProperty.Local {
    private static DomainRestrictedProperty instance = null;

    private DomainRestrictedProperty() {
    }

    public static synchronized DomainRestrictedProperty instance() {
        if (instance == null) {
            instance = new DomainRestrictedProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Domain restricted";
    }

    @Override
    public String getDescription() {
        return "Each atom in the head contains all variables from the body or none.";
    }

    @Override
    public int check(Rule rule) {
        Set<Variable> bodyVars = rule.getBody().getVariables();
        for (Atom a : rule.getHead()) {
            boolean none = true;
            boolean all = true;
            for (Term term : bodyVars) {
                if (a.getTerms().contains(term)) {
                    none = false;
                } else {
                    all = false;
                }
                if (none || all) continue;
                return -1;
            }
        }
        return 1;
    }

    @Override
    public String getLabel() {
        return "dr";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(FUSProperty.instance());
        return gen;
    }
}

