/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.JointlyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyFrontierGuardedSetProperty;
import java.util.LinkedList;
import java.util.Set;

public final class FrontierGuardedProperty
extends RuleSetProperty.Local {
    private static FrontierGuardedProperty instance = null;

    private FrontierGuardedProperty() {
    }

    public static synchronized FrontierGuardedProperty instance() {
        if (instance == null) {
            instance = new FrontierGuardedProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Frontier-guarded";
    }

    @Override
    public String getDescription() {
        return "At least one atom in the body contains all the variables from the frontier.";
    }

    @Override
    public int check(Rule rule) {
        Set<Variable> frontier = rule.getFrontier();
        boolean isGuarded = true;
        for (Atom a : rule.getBody()) {
            isGuarded = true;
            for (Term term : frontier) {
                if (a.getTerms().contains(term)) continue;
                isGuarded = false;
                break;
            }
            if (!isGuarded) continue;
            break;
        }
        if (isGuarded) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "fg";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(WeaklyFrontierGuardedSetProperty.instance());
        gen.add(JointlyFrontierGuardedSetProperty.instance());
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

