/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.core.Rules;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.JointlyAffectedPositionSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;
import java.util.Set;

public final class JointlyFrontierGuardedSetProperty
extends RuleSetProperty.Default {
    private static JointlyFrontierGuardedSetProperty instance = null;

    private JointlyFrontierGuardedSetProperty() {
    }

    public static synchronized JointlyFrontierGuardedSetProperty instance() {
        if (instance == null) {
            instance = new JointlyFrontierGuardedSetProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Jointly-frontier guarded";
    }

    @Override
    public String getDescription() {
        return "At least one atom in the body of each rule contains all affected variable from the frontier (cf. affected position set).";
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (this.check(ruleSet.getJointlyAffectedPositionSet())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "jfg";
    }

    private boolean check(JointlyAffectedPositionSet jointlyAffectedPositionSet) {
        for (Rule r : jointlyAffectedPositionSet.getRules()) {
            Set affectedVars = jointlyAffectedPositionSet.getAllAffectedFrontierVariables(r);
            if (Rules.isThereOneAtomThatContainsAllVars(r.getBody(), affectedVars)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

