/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.GraalConstant;
import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Predicate;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.RuleSet;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.homomorphism.HomomorphismException;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.DefaultConjunctiveQuery;
import fr.lirmm.graphik.integraal.core.DefaultRule;
import fr.lirmm.graphik.integraal.core.Rules;
import fr.lirmm.graphik.integraal.core.TreeMapSubstitution;
import fr.lirmm.graphik.integraal.core.ruleset.LinkedListRuleSet;
import fr.lirmm.graphik.integraal.core.term.DefaultTermFactory;
import fr.lirmm.graphik.integraal.forward_chaining.StaticChase;
import fr.lirmm.graphik.integraal.homomorphism.SmartHomomorphism;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.MFAProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;
import java.util.List;

public final class MSAProperty
extends RuleSetProperty.Default {
    private static MSAProperty instance = null;
    private static final Predicate D = GraalConstant.freshPredicate(2);
    private static final Predicate S = GraalConstant.freshPredicate(2);
    private static final Predicate C = GraalConstant.freshPredicate(1);
    private static final Term FAKE = GraalConstant.freshConstant();

    private MSAProperty() {
    }

    public static synchronized MSAProperty instance() {
        if (instance == null) {
            instance = new MSAProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Model-summarizing acyclicity";
    }

    @Override
    public String getDescription() {
        return "Approximates MFA with a lower complexity.";
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        RuleSet R = MSAProperty.translateToMSA(ruleSet);
        InMemoryAtomSet A = Rules.criticalInstance(ruleSet);
        try {
            StaticChase.executeChase((AtomSet)A, R);
        }
        catch (ChaseException e) {
            return 0;
        }
        DefaultConjunctiveQuery Q = new DefaultConjunctiveQuery();
        DefaultAtom q = new DefaultAtom(C);
        q.setTerm(0, FAKE);
        Q.getAtomSet().add(q);
        try {
            if (SmartHomomorphism.instance().exist(Q, A)) {
                return -1;
            }
            return 1;
        }
        catch (HomomorphismException e) {
            return 0;
        }
    }

    @Override
    public String getLabel() {
        return "msa";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(FESProperty.instance());
        gen.add(BTSProperty.instance());
        gen.add(MFAProperty.instance());
        return gen;
    }

    public static RuleSet translateToMSA(Iterable<Rule> rules) {
        LinkedListRuleSet R = new LinkedListRuleSet();
        for (Rule r : rules) {
            for (Rule r2 : MSAProperty.translateRuleToMSA(r)) {
                R.add(r2);
            }
        }
        DefaultRule rule = new DefaultRule();
        DefaultAtom s = new DefaultAtom(S);
        s.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
        s.setTerm(1, DefaultTermFactory.instance().createVariable("X2"));
        DefaultAtom d = new DefaultAtom(D);
        d.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
        d.setTerm(1, DefaultTermFactory.instance().createVariable("X2"));
        rule.getBody().add(s);
        rule.getHead().add(d);
        R.add(rule);
        s = new DefaultAtom(S);
        d = new DefaultAtom(D);
        DefaultAtom d2 = new DefaultAtom(D);
        d.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
        d.setTerm(1, DefaultTermFactory.instance().createVariable("X2"));
        s.setTerm(0, DefaultTermFactory.instance().createVariable("X2"));
        s.setTerm(1, DefaultTermFactory.instance().createVariable("X3"));
        d2.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
        d2.setTerm(1, DefaultTermFactory.instance().createVariable("X3"));
        rule = new DefaultRule();
        rule.getBody().add(d);
        rule.getBody().add(s);
        rule.getHead().add(d2);
        R.add(rule);
        return R;
    }

    public static List<Rule> translateRuleToMSA(Rule r) {
        LinkedList<Rule> result = new LinkedList<Rule>();
        Substitution s = MSAProperty.buildMSASubstitution(r);
        DefaultRule r2 = new DefaultRule(r);
        for (Term term : r2.getExistentials()) {
            Predicate Fir = GraalConstant.freshPredicate(1);
            DefaultAtom f = new DefaultAtom(Fir);
            f.setTerm(0, term);
            r2.getHead().add(f);
            for (Term term2 : r2.getFrontier()) {
                DefaultAtom ss = new DefaultAtom(S);
                ss.setTerm(0, term2);
                ss.setTerm(1, term);
                r2.getHead().add(ss);
            }
            DefaultRule r3 = new DefaultRule();
            DefaultAtom defaultAtom = new DefaultAtom(Fir);
            defaultAtom.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
            DefaultAtom f2 = new DefaultAtom(Fir);
            f2.setTerm(0, DefaultTermFactory.instance().createVariable("X2"));
            DefaultAtom d = new DefaultAtom(D);
            d.setTerm(0, DefaultTermFactory.instance().createVariable("X1"));
            d.setTerm(1, DefaultTermFactory.instance().createVariable("X2"));
            r3.getBody().add(defaultAtom);
            r3.getBody().add(d);
            r3.getBody().add(f2);
            DefaultAtom c = new DefaultAtom(C);
            c.setTerm(0, FAKE);
            r3.getHead().add(c);
            result.add(r3);
        }
        r2.setHead(s.createImageOf(r2.getHead()));
        result.add(r2);
        return result;
    }

    public static Substitution buildMSASubstitution(Rule r) {
        TreeMapSubstitution s = new TreeMapSubstitution();
        for (Variable yi : r.getExistentials()) {
            s.put(yi, GraalConstant.freshConstant());
        }
        return s;
    }
}

