/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.FESProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.MFAProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.MSAProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyStickyProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;

public final class WeaklyAcyclicProperty
extends RuleSetProperty.Default {
    private static WeaklyAcyclicProperty instance = null;

    private WeaklyAcyclicProperty() {
    }

    public static synchronized WeaklyAcyclicProperty instance() {
        if (instance == null) {
            instance = new WeaklyAcyclicProperty();
        }
        return instance;
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (ruleSet.getGraphPositionDependencies().isWeaklyAcyclic()) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getFullName() {
        return "Weakly acyclic";
    }

    @Override
    public String getDescription() {
        return "All predicate positions in the graph of position dependencies have finite rank (i.e., there is no circuit with a special edge).";
    }

    @Override
    public String getLabel() {
        return "wa";
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(WeaklyStickyProperty.instance());
        gen.add(FESProperty.instance());
        gen.add(BTSProperty.instance());
        gen.add(MSAProperty.instance());
        gen.add(MFAProperty.instance());
        return gen;
    }
}

