/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.core.Rules;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.AffectedPositionSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.BTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.GBTSProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.JointlyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.WeaklyFrontierGuardedSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;
import java.util.LinkedList;
import java.util.Set;

public final class WeaklyGuardedSetProperty
extends RuleSetProperty.Default {
    private static WeaklyGuardedSetProperty instance = null;

    private WeaklyGuardedSetProperty() {
    }

    public static synchronized WeaklyGuardedSetProperty instance() {
        if (instance == null) {
            instance = new WeaklyGuardedSetProperty();
        }
        return instance;
    }

    @Override
    public String getFullName() {
        return "Weakly guarded";
    }

    @Override
    public String getDescription() {
        return "At least one atom in the body of each rule contains all affected variables from the body (cf. affected position set).";
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (this.check(ruleSet.getAffectedPositionSet())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getLabel() {
        return "wg";
    }

    private boolean check(AffectedPositionSet affectedPositionSet) {
        for (Rule r : affectedPositionSet.getRules()) {
            Set affectedVars = affectedPositionSet.getAllAffectedVariables(r.getBody());
            if (Rules.isThereOneAtomThatContainsAllVars(r.getBody(), affectedVars)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterable<RuleSetProperty> getGeneralisations() {
        LinkedList<RuleSetProperty> gen = new LinkedList<RuleSetProperty>();
        gen.add(WeaklyFrontierGuardedSetProperty.instance());
        gen.add(JointlyFrontierGuardedSetProperty.instance());
        gen.add(GBTSProperty.instance());
        gen.add(BTSProperty.instance());
        return gen;
    }
}

