/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.rulesetanalyser.property;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.GraphPositionDependencies;
import fr.lirmm.graphik.integraal.rulesetanalyser.graph.MarkedVariableSet;
import fr.lirmm.graphik.integraal.rulesetanalyser.property.RuleSetProperty;
import fr.lirmm.graphik.integraal.rulesetanalyser.util.AnalyserRuleSet;

public final class WeaklyStickyProperty
extends RuleSetProperty.Default {
    private static WeaklyStickyProperty instance = null;

    private WeaklyStickyProperty() {
    }

    public static synchronized WeaklyStickyProperty instance() {
        if (instance == null) {
            instance = new WeaklyStickyProperty();
        }
        return instance;
    }

    @Override
    public int check(AnalyserRuleSet ruleSet) {
        if (this.check(ruleSet.getMarkedVariableSet(), ruleSet.getGraphPositionDependencies())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String getFullName() {
        return "Weakly sticky";
    }

    @Override
    public String getDescription() {
        return "This class does not belong to any abstract class defined earlier. It is a generalisation of Sticky and Weakly-Acyclic. It relies upon the same graph of position dependencies as the Weakly-Acyclic test and upon the same marking procedure as the Sticky test. All marked variables that occur more than once in a rule body appear at some position of finite rank.";
    }

    @Override
    public String getLabel() {
        return "ws";
    }

    private boolean check(MarkedVariableSet markedVariableSet, GraphPositionDependencies gpd) {
        for (MarkedVariableSet.MarkedRule mrule : markedVariableSet.getMarkedRuleCollection()) {
            for (Term mvar : mrule.markedVars) {
                int nbOccurence = 0;
                boolean thereIsAFiniteRank = false;
                for (Atom a : mrule.rule.getBody()) {
                    int position = -1;
                    for (Term t : a) {
                        ++position;
                        if (!mvar.equals(t)) continue;
                        ++nbOccurence;
                        if (!gpd.isFiniteRank(a.getPredicate(), position)) continue;
                        thereIsAFiniteRank = true;
                    }
                }
                if (nbOccurence <= true || thereIsAFiniteRank) continue;
                return false;
            }
        }
        return true;
    }
}

