/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

import fr.lirmm.graphik.util.URI;
import fr.lirmm.graphik.util.URIUtils;

public final class DefaultURI
implements URI {
    private String prefix;
    private String localname;

    public DefaultURI(String prefix, String localname) {
        this.prefix = prefix;
        this.localname = localname;
    }

    public DefaultURI(String uri) {
        this.prefix = URIUtils.getPrefix(uri);
        this.localname = URIUtils.getLocalName(uri);
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLocalname() {
        return this.localname;
    }

    @Override
    public int compareTo(URI uri) {
        return this.toString().compareTo(uri.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof URI)) {
            return false;
        }
        URI other = (URI)obj;
        return this.equals(other);
    }

    public boolean equals(URI other) {
        return this.toString().equals(other.toString());
    }

    public String toString() {
        return this.prefix + this.localname;
    }
}

