/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util;

import fr.lirmm.graphik.util.Prefix;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class PrefixManager
implements Iterable<Prefix> {
    private static final PrefixManager INSTANCE = new PrefixManager();
    private final Map<String, Prefix> PREFIX_MAP = new TreeMap<String, Prefix>();
    private final Map<String, Prefix> INVERSE_PREFIX_MAP = new TreeMap<String, Prefix>();

    public static PrefixManager instance() {
        return INSTANCE;
    }

    public void putPrefix(Prefix prefix) {
        this.PREFIX_MAP.put(prefix.getPrefixName(), prefix);
        this.INVERSE_PREFIX_MAP.put(prefix.getPrefix(), prefix);
    }

    public Prefix getPrefixByValue(String string) {
        return this.INVERSE_PREFIX_MAP.get(string);
    }

    @Override
    public Iterator<Prefix> iterator() {
        return this.PREFIX_MAP.values().iterator();
    }

    static {
        INSTANCE.putPrefix(Prefix.XSD);
    }
}

