/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.collections;

import java.util.HashMap;
import java.util.Map;

class TrieNode<T, V> {
    private Map<T, TrieNode<T, V>> children = new HashMap<T, TrieNode<T, V>>();
    private boolean isLeaf = true;
    private V value;

    @SafeVarargs
    public final V put(V value, int index, T ... word) {
        if (word.length <= index) {
            V tmp = this.value;
            this.value = value;
            return tmp;
        }
        this.isLeaf = false;
        T charac = word[index];
        TrieNode<T, V> child = this.children.get(charac);
        if (child == null) {
            child = new TrieNode<T, V>();
            this.children.put(charac, child);
        }
        return child.put(value, index + 1, word);
    }

    @SafeVarargs
    public final V get(int index, T ... word) {
        if (word.length <= index) {
            return this.value;
        }
        if (this.isLeaf) {
            return null;
        }
        T charac = word[index];
        TrieNode<T, V> child = this.children.get(charac);
        if (child == null) {
            return null;
        }
        return child.get(index + 1, word);
    }
}

