/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph;

import fr.lirmm.graphik.util.graph.HyperEdge;
import fr.lirmm.graphik.util.graph.HyperGraph;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultHyperGraph
implements HyperGraph {
    private ArrayList<LinkedList<Integer>> adjacencyList;
    private int nbVertices;

    public DefaultHyperGraph() {
        this.nbVertices = 0;
        this.adjacencyList = new ArrayList();
    }

    public DefaultHyperGraph(int nbVerticesInit) {
        this.nbVertices = nbVerticesInit;
        this.adjacencyList = new ArrayList(nbVerticesInit);
        for (int i = 0; i < this.nbVertices; ++i) {
            this.adjacencyList.add(new LinkedList());
        }
    }

    @Override
    public int nbVertices() {
        return this.nbVertices;
    }

    @Override
    public int addVertex() {
        this.adjacencyList.add(new LinkedList());
        return this.nbVertices++;
    }

    @Override
    public Iterator<Integer> adjacencyList(int v) {
        return this.adjacencyList.get(v).iterator();
    }

    @Override
    public void add(HyperEdge e) {
        Iterator<Integer> it1 = e.vertices();
        while (it1.hasNext()) {
            int v1 = it1.next();
            Iterator<Integer> it2 = e.vertices();
            while (it2.hasNext()) {
                int v2 = it2.next();
                if (v1 == v2) continue;
                this.adjacencyList.get(v1).add(v2);
            }
        }
    }

    @Override
    public void addEdge(int ... vertices) {
        for (int i = 0; i < vertices.length - 1; ++i) {
            for (int j = i + 1; j < vertices.length; ++j) {
                this.adjacencyList.get(vertices[i]).add(vertices[j]);
                this.adjacencyList.get(vertices[j]).add(vertices[i]);
            }
        }
    }
}

