/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph.algorithm;

import fr.lirmm.graphik.util.graph.DefaultDirectedEdge;
import fr.lirmm.graphik.util.graph.DirectedEdge;
import fr.lirmm.graphik.util.graph.Graph;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class BiconnectedComponents {
    private BiconnectedComponents() {
    }

    public static List<Set<Integer>> execute(Graph g) {
        Data d = new Data();
        d.components = new LinkedList<Set<Integer>>();
        d.g = g;
        d.i = 0;
        d.stack = new LinkedList<DirectedEdge>();
        d.number = new int[g.nbVertices()];
        Arrays.fill(d.number, -1);
        d.lowpt = new int[g.nbVertices()];
        Arrays.fill(d.lowpt, -1);
        for (int v = 0; v < g.nbVertices(); ++v) {
            if (d.number[v] != -1) continue;
            BiconnectedComponents.biconnect(d, v, 0);
        }
        return d.components;
    }

    private static void biconnect(Data d, int v, int u) {
        d.number[v] = ++d.i;
        d.lowpt[v] = d.i;
        Iterator<Integer> adjacencyIt = d.g.adjacencyList(v);
        while (adjacencyIt.hasNext()) {
            int w = adjacencyIt.next();
            if (d.number[w] == -1) {
                DirectedEdge e;
                d.stack.push(new DefaultDirectedEdge(v, w));
                BiconnectedComponents.biconnect(d, w, v);
                d.lowpt[v] = Math.min(d.lowpt[v], d.lowpt[w]);
                if (d.lowpt[w] < d.number[v]) continue;
                d.currentComponent = new TreeSet<Integer>();
                d.components.add(d.currentComponent);
                while (d.number[d.stack.peek().getTail()] >= d.number[w]) {
                    e = d.stack.pop();
                    d.currentComponent.add(e.getTail());
                    d.currentComponent.add(e.getHead());
                }
                e = d.stack.pop();
                d.currentComponent.add(e.getTail());
                d.currentComponent.add(e.getHead());
                continue;
            }
            if (d.number[w] >= d.number[v] || w == u) continue;
            d.stack.push(new DefaultDirectedEdge(v, w));
            d.lowpt[v] = Math.min(d.lowpt[v], d.number[w]);
        }
    }

    private static class Data {
        Graph g;
        int i;
        int[] number;
        int[] lowpt;
        Deque<DirectedEdge> stack;
        List<Set<Integer>> components;
        Set<Integer> currentComponent;

        private Data() {
        }
    }
}

