/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.graph.algorithm;

import fr.lirmm.graphik.util.graph.DefaultDirectedEdge;
import fr.lirmm.graphik.util.graph.DefaultHyperGraph;
import fr.lirmm.graphik.util.graph.DirectedEdge;
import fr.lirmm.graphik.util.graph.HyperGraph;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class BiconnectedComponentsForHyperGraph {
    private BiconnectedComponentsForHyperGraph() {
    }

    public static Data execute(HyperGraph g) {
        Data d = new Data();
        d.components = new LinkedList<Set<Integer>>();
        d.g = g;
        d.i = 0;
        d.stack = new LinkedList<DirectedEdge>();
        d.number = new int[g.nbVertices() + 1];
        d.access = new int[g.nbVertices() + 1];
        d.isAccesseur = new boolean[g.nbVertices() + 1];
        d.isEntry = new boolean[g.nbVertices() + 1];
        d.lowpt = new int[g.nbVertices() + 1];
        for (int v = 1; v <= g.nbVertices(); ++v) {
            if (d.number[v] != 0) continue;
            BiconnectedComponentsForHyperGraph.biconnect(d, v, 0);
        }
        return d;
    }

    private static void biconnect(Data d, int v, int u) {
        d.number[v] = ++d.i;
        d.lowpt[v] = d.i;
        d.access[v] = u;
        Iterator<Integer> adjacencyIt = d.g.adjacencyList(v);
        while (adjacencyIt.hasNext()) {
            int w = adjacencyIt.next();
            if (d.number[w] == 0) {
                DirectedEdge e;
                d.stack.push(new DefaultDirectedEdge(v, w));
                BiconnectedComponentsForHyperGraph.biconnect(d, w, v);
                d.lowpt[v] = Math.min(d.lowpt[v], d.lowpt[w]);
                if (d.lowpt[w] < d.number[v]) continue;
                d.isAccesseur[v] = true;
                d.isEntry[w] = true;
                d.currentComponent = new TreeSet<Integer>();
                d.components.add(d.currentComponent);
                while (d.number[d.stack.peek().getTail()] >= d.number[w]) {
                    e = d.stack.pop();
                    d.currentComponent.add(e.getTail());
                    d.currentComponent.add(e.getHead());
                }
                e = d.stack.pop();
                d.currentComponent.add(e.getTail());
                d.currentComponent.add(e.getHead());
                continue;
            }
            if (d.number[w] >= d.number[v] || w == u) continue;
            d.stack.push(new DefaultDirectedEdge(v, w));
            d.lowpt[v] = Math.min(d.lowpt[v], d.number[w]);
        }
    }

    public static void main(String[] args) {
        DefaultHyperGraph g = new DefaultHyperGraph(20);
        g.addEdge(1, 2, 3);
        g.addEdge(3, 4);
        g.addEdge(14, 10);
        g.addEdge(10, 12, 13);
        g.addEdge(10, 7, 11);
        g.addEdge(7, 11);
        g.addEdge(5, 6, 7, 8);
        g.addEdge(7, 8, 9);
        g.addEdge(8, 19, 20);
        g.addEdge(9, 18);
        g.addEdge(9, 15);
        g.addEdge(15, 16, 17);
    }

    public static class Data {
        public boolean[] isEntry;
        public boolean[] isAccesseur;
        int[] numberinv;
        LinkedList<Integer> order;
        public int[] access;
        HyperGraph g;
        int i;
        public int[] number;
        int[] lowpt;
        Deque<DirectedEdge> stack;
        List<Set<Integer>> components;
        Set<Integer> currentComponent;

        public String toString() {
            int v;
            StringBuilder sb = new StringBuilder();
            sb.append("").append("\t{ vertices : ");
            for (v = 0; v <= this.g.nbVertices(); ++v) {
                sb.append("\t").append(v);
            }
            sb.append(" }\n").append("\t{   number : ");
            for (v = 0; v <= this.g.nbVertices(); ++v) {
                sb.append("\t").append(this.number[v]);
            }
            sb.append(" }\n").append("\t{    lowpt : ");
            for (v = 0; v <= this.g.nbVertices(); ++v) {
                sb.append("\t").append(this.lowpt[v]);
            }
            sb.append(" }\n").append("\t{   access : ");
            for (v = 0; v <= this.g.nbVertices(); ++v) {
                sb.append("\t").append(this.access[v]);
            }
            sb.append(" }\n").append("\t{   stack :");
            for (DirectedEdge directedEdge : this.stack) {
                sb.append(directedEdge);
            }
            sb.append(" }\n").append("\t{ components :");
            for (Set set : this.components) {
                sb.append(set);
            }
            sb.append(" }\n").append("\t{ current component :").append(this.currentComponent).append(" }\n}");
            return sb.toString();
        }
    }
}

