/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.profiler;

import fr.lirmm.graphik.util.TimeUnit;
import fr.lirmm.graphik.util.profiler.Profiler;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractProfiler
implements Profiler {
    private PrintStream out = null;
    private SimpleDateFormat dateFormat = new SimpleDateFormat();
    private TimeUnit timeUnit;
    private final Map<String, Long> startTimeMap = new TreeMap<String, Long>();
    private final Map<String, Object> map = new TreeMap<String, Object>();

    public AbstractProfiler() {
        this.timeUnit = TimeUnit.MILLISECONDS;
    }

    public AbstractProfiler(PrintStream out) {
        this();
        this.setOutputStream(out);
    }

    public AbstractProfiler(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public AbstractProfiler(PrintStream out, TimeUnit timeUnit) {
        this(timeUnit);
        this.setOutputStream(out);
    }

    @Override
    public boolean isProfilingEnabled() {
        return true;
    }

    @Override
    public void setDateFormat(String pattern) {
        this.dateFormat.applyPattern(pattern);
    }

    @Override
    public void setOutputStream(PrintStream out) {
        this.out = out;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    @Override
    public void start(String key) {
        this.startTimeMap.put(key, this.getTime());
    }

    @Override
    public void stop(String key) {
        Long oldTime = (Long)this.map.get(key);
        if (oldTime == null) {
            oldTime = 0L;
        }
        long elapsedTimeNano = this.getTime() - this.startTimeMap.get(key);
        Long newTime = oldTime + this.timeUnit.round(elapsedTimeNano, TimeUnit.NANOSECONDS);
        this.map.put(key, newTime);
        if (this.out != null) {
            this.printPrefix();
            this.out.print(key);
            this.out.print(": ");
            this.out.print(newTime);
            this.out.print(this.timeUnit.getAbbreviation());
            this.out.print("\n");
        }
    }

    @Override
    public void put(String key, Object value) {
        this.map.put(key, value);
        if (this.out != null) {
            this.printPrefix();
            this.out.print(key);
            this.out.print(": ");
            this.out.print(value.toString());
            this.out.println();
        }
    }

    @Override
    public void incr(String key, int value) {
        Object o = this.map.get(key);
        if (o == null) {
            o = 0;
        }
        Integer i = (Integer)o;
        i = i + value;
        this.map.put(key, i);
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public Map<String, Object> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public void clear(String key) {
        this.startTimeMap.remove(key);
        this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void trace(String ... strings) {
        if (this.out != null) {
            this.printPrefix();
            for (String s : strings) {
                this.out.print(s);
            }
            this.out.println();
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n");
        for (Map.Entry<String, Object> e : this.map.entrySet()) {
            sb.append("\t").append(e.getKey()).append(": ").append(e.getValue()).append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected abstract long getTime();

    private void printPrefix() {
        this.out.print("Profiler [");
        this.out.print(this.dateFormat.format(new Date()));
        this.out.print("] ");
    }
}

