/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.ArrayBlockingStream;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;

public class ArrayBlockingQueueToCloseableIteratorAdapter<T>
extends AbstractCloseableIterator<T> {
    private ArrayBlockingStream<T> buffer;

    public ArrayBlockingQueueToCloseableIteratorAdapter(CloseableIterator<T> it) {
        this(it, 128);
    }

    public ArrayBlockingQueueToCloseableIteratorAdapter(CloseableIterator<T> it, int bufferSize) {
        this.buffer = new ArrayBlockingStream(bufferSize);
        Thread t = new Thread(new Producer(it, this.buffer));
        t.start();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    @Override
    public boolean hasNext() {
        return this.buffer.hasNext();
    }

    @Override
    public T next() {
        return this.buffer.next();
    }

    private class Producer
    implements Runnable {
        private CloseableIterator<T> it;
        private ArrayBlockingStream<T> buffer;

        Producer(CloseableIterator<T> it, ArrayBlockingStream<T> buffer) {
            this.it = it;
            this.buffer = buffer;
        }

        @Override
        public void run() {
            try {
                while (this.it.hasNext()) {
                    this.buffer.write(this.it.next());
                }
            }
            catch (IteratorException e) {
                throw new Error("Untreated exception");
            }
            finally {
                this.it.close();
                this.buffer.close();
            }
        }
    }
}

