/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.ArrayList;
import java.util.List;

public class CloseableIteratorAccumulator<E>
extends AbstractCloseableIterator<E> {
    private CloseableIterator<E> it;
    List<E> accu = new ArrayList();
    boolean hasNext = false;
    boolean nextIsStore = false;

    public CloseableIteratorAccumulator(CloseableIterator<E> it) throws IteratorException {
        this.it = it;
        this.hasNext = it.hasNext();
    }

    @Override
    public boolean hasNext() throws IteratorException {
        if (this.nextIsStore) {
            this.hasNext = this.it.hasNext();
            this.nextIsStore = false;
        }
        return this.hasNext;
    }

    @Override
    public E next() throws IteratorException {
        E ret = this.it.next();
        if (!this.nextIsStore) {
            this.accu.add(ret);
            this.nextIsStore = true;
        }
        return ret;
    }

    @Override
    public void close() {
        this.it.close();
    }

    public CloseableIteratorAccumulator<E> consumeAll() throws IteratorException {
        while (this.hasNext()) {
            this.next();
        }
        return this;
    }

    public E[] toArray() {
        return this.accu.toArray();
    }

    public List<E> getList() {
        return new ArrayList<E>(this.accu);
    }
}

