/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import java.util.Iterator;
import java.util.stream.Stream;

public class CloseableIteratorAdapter<T>
implements CloseableIteratorWithoutException<T> {
    protected Iterator<T> iterator;
    protected Stream<T> stream = null;
    protected boolean isClosed = false;

    public CloseableIteratorAdapter(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    public CloseableIteratorAdapter(Stream<T> stream) {
        this.stream = stream;
        this.iterator = stream.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.isClosed) {
            return null;
        }
        return this.iterator.next();
    }

    @Override
    public void close() {
        this.isClosed = true;
        try {
            if (this.iterator instanceof AutoCloseable) {
                ((AutoCloseable)((Object)this.iterator)).close();
            } else if (this.stream != null) {
                this.stream.close();
            }
        }
        catch (Exception e) {
            throw new Error("Untreated exception", e);
        }
    }
}

