/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.AbstractCloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIterable;
import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import java.util.Stack;

public class CloseableIteratorRecursive<E>
extends AbstractCloseableIterator<E> {
    private Stack<CloseableIterator<E>> stackIterator = new Stack();
    private CloseableIterator<E> currentIterator;
    private E next;

    public CloseableIteratorRecursive(CloseableIterator<E> primaryIterator) {
        this.currentIterator = primaryIterator;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        if (this.next != null) {
            return true;
        }
        if (this.currentIterator == null) {
            return false;
        }
        while (!this.currentIterator.hasNext()) {
            this.currentIterator.close();
            if (this.stackIterator.isEmpty()) {
                this.currentIterator = null;
                return false;
            }
            this.currentIterator = this.stackIterator.pop();
        }
        E next = this.currentIterator.next();
        if (next instanceof CloseableIterator) {
            this.stackIterator.push(this.currentIterator);
            this.currentIterator = (CloseableIterator)next;
            return this.currentIterator.hasNext();
        }
        if (next instanceof CloseableIterable) {
            this.stackIterator.push(this.currentIterator);
            this.currentIterator = ((CloseableIterable)next).iterator();
            return this.currentIterator.hasNext();
        }
        this.next = next;
        return true;
    }

    @Override
    public E next() throws IteratorException {
        if (this.next == null) {
            this.hasNext();
        }
        E ret = this.next;
        this.next = null;
        return ret;
    }

    @Override
    public void close() {
        if (this.currentIterator == null) {
            return;
        }
        this.currentIterator.close();
        while (!this.stackIterator.isEmpty()) {
            this.stackIterator.pop().close();
        }
    }
}

