/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream;

import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.CloseableIteratorAdapter;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.EmptyCloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.SingletonCloseableIteratorWithoutException;
import fr.lirmm.graphik.util.stream.UniqIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public final class Iterators {
    private Iterators() {
    }

    public static <T> CloseableIteratorWithoutException<T> emptyIterator() {
        return new EmptyCloseableIteratorWithoutException();
    }

    public static <E> CloseableIteratorWithoutException<E> singletonIterator(E e) {
        return new SingletonCloseableIteratorWithoutException<E>(e);
    }

    public static int count(CloseableIterator<?> it) throws IteratorException {
        int i = 0;
        while (it.hasNext()) {
            ++i;
            it.next();
        }
        return i;
    }

    public static int count(CloseableIteratorWithoutException<?> it) {
        try {
            return Iterators.count(it);
        }
        catch (IteratorException e) {
            throw new Error("Should never happen");
        }
    }

    public static <T> CloseableIterator<T> uniqLocaly(CloseableIterator<T> it) {
        return new UniqIterator<T>(it);
    }

    public static <T extends Comparable<T>> CloseableIterator<T> sort(CloseableIterator<T> it) throws IteratorException {
        LinkedList<Comparable> substitutionList = new LinkedList<Comparable>();
        while (it.hasNext()) {
            substitutionList.add((Comparable)it.next());
        }
        it.close();
        Collections.sort(substitutionList);
        return new CloseableIteratorAdapter(substitutionList.iterator());
    }

    public static <T extends Comparable<T>> Iterator<T> sort(Iterator<T> it) {
        LinkedList<Comparable> substitutionList = new LinkedList<Comparable>();
        while (it.hasNext()) {
            substitutionList.add((Comparable)it.next());
        }
        Collections.sort(substitutionList);
        return substitutionList.iterator();
    }

    public static <T extends Comparable<T>> CloseableIterator<T> uniq(CloseableIterator<T> it) throws IteratorException {
        TreeSet<Comparable> substitutionSet = new TreeSet<Comparable>();
        while (it.hasNext()) {
            substitutionSet.add((Comparable)it.next());
        }
        it.close();
        return new CloseableIteratorAdapter(substitutionSet.iterator());
    }

    public static <T extends Comparable<T>> Iterator<T> uniq(Iterator<T> it) {
        TreeSet<Comparable> substitutionSet = new TreeSet<Comparable>();
        while (it.hasNext()) {
            substitutionSet.add((Comparable)it.next());
        }
        return substitutionSet.iterator();
    }

    public static <T> List<T> toList(CloseableIterator<T> it) throws IteratorException {
        LinkedList<T> list = new LinkedList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it.close();
        return list;
    }

    public static <T> List<T> toList(CloseableIteratorWithoutException<T> it) {
        LinkedList<T> list = new LinkedList<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it.close();
        return list;
    }

    public static <T> Set<T> toSet(CloseableIterator<T> it) throws IteratorException {
        HashSet<T> list = new HashSet<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it.close();
        return list;
    }

    public static <T> Set<T> toSet(CloseableIteratorWithoutException<T> it) {
        HashSet<T> list = new HashSet<T>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        it.close();
        return list;
    }
}

