/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.util.stream.converter;

import fr.lirmm.graphik.util.stream.CloseableIterator;
import fr.lirmm.graphik.util.stream.IteratorException;
import fr.lirmm.graphik.util.stream.converter.ConversionException;
import fr.lirmm.graphik.util.stream.converter.Converter;

public class ConverterIterator<U, T>
implements CloseableIterator<T> {
    private final CloseableIterator<U> it;
    private final Converter<U, T> converter;

    public ConverterIterator(CloseableIterator<U> it, Converter<U, T> converter) {
        this.converter = converter;
        this.it = it;
    }

    @Override
    public boolean hasNext() throws IteratorException {
        return this.it.hasNext();
    }

    @Override
    public T next() throws IteratorException {
        try {
            return this.converter.convert(this.it.next());
        }
        catch (ConversionException e) {
            throw new IteratorException(e);
        }
    }

    @Override
    public void close() {
        this.it.close();
    }
}

