/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractAtom
implements Atom {
    @Override
    public Set<Constant> getConstants() {
        HashSet<Constant> typedTerms = new HashSet<Constant>();
        for (Term term : this.getTerms()) {
            if (!term.isConstant()) continue;
            typedTerms.add((Constant)term);
        }
        return typedTerms;
    }

    @Override
    public Set<Variable> getVariables() {
        HashSet<Variable> typedTerms = new HashSet<Variable>();
        for (Term term : this.getTerms()) {
            if (!term.isVariable()) continue;
            typedTerms.add((Variable)term);
        }
        return typedTerms;
    }

    @Override
    public Set<Literal> getLiterals() {
        HashSet<Literal> typedTerms = new HashSet<Literal>();
        for (Term term : this.getTerms()) {
            if (!term.isLiteral()) continue;
            typedTerms.add((Literal)term);
        }
        return typedTerms;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getPredicate() == null ? 0 : this.getPredicate().hashCode());
        for (Term t : this.getTerms()) {
            result = 31 * result + t.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)obj;
        if (this.getPredicate() == null ? other.getPredicate() != null : !this.getPredicate().equals(other.getPredicate())) {
            return false;
        }
        if (this.getTerms() == null) {
            if (other.getTerms() != null) {
                return false;
            }
        } else {
            if (this.getTerms().size() != other.getTerms().size()) {
                return false;
            }
            for (int i = 0; i < this.getTerms().size(); ++i) {
                if (this.getTerm(i).equals(other.getTerm(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int compareTo(Atom other) {
        int cmpVal = this.getPredicate().compareTo(other.getPredicate());
        if (cmpVal == 0) {
            List<Term> thisTerms = this.getTerms();
            List<Term> otherTerms = other.getTerms();
            cmpVal = thisTerms.size() < otherTerms.size() ? -1 : (thisTerms.size() == otherTerms.size() ? 0 : 1);
            for (int i = 0; cmpVal == 0 && i < thisTerms.size(); ++i) {
                cmpVal = thisTerms.get(i).compareTo(otherTerms.get(i));
            }
        }
        return cmpVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.getPredicate().toString());
        sb.append('(');
        boolean bool = false;
        for (Term term : this) {
            if (bool) {
                sb.append(',');
            }
            sb.append(term.toString());
            bool = true;
        }
        sb.append(')');
    }

    @Override
    public Iterator<Term> iterator() {
        return this.getTerms().iterator();
    }
}

