/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.core;

import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import java.util.Objects;

public abstract class AbstractTerm
implements Term {
    private static final long serialVersionUID = 5255497469444828872L;

    @Override
    public String getLabel() {
        return this.getIdentifier().toString();
    }

    @Override
    public final boolean isConstant() {
        return this instanceof Constant;
    }

    @Override
    public final boolean isVariable() {
        return this instanceof Variable;
    }

    @Override
    public final boolean isLiteral() {
        return this instanceof Literal;
    }

    @Override
    public int compareTo(Term o) {
        if (this.equals(o)) {
            return 0;
        }
        int cmp = this.getType().compareTo(o.getType());
        if (cmp == 0 && (cmp = this.getIdentifier().getClass().toString().compareTo(o.getIdentifier().getClass().toString())) == 0) {
            cmp = this.getIdentifier().toString().compareTo(o.getIdentifier().toString());
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        Term other = (Term)obj;
        return this.equals(other);
    }

    public boolean equals(Term term) {
        return Objects.equals((Object)this.getType(), (Object)term.getType()) && Objects.equals(this.getIdentifier(), term.getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode() + 47 * this.getType().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isLiteral()) {
            sb.append('\"');
        }
        sb.append(this.getLabel());
        if (this.isLiteral()) {
            sb.append('\"');
        }
        return sb.toString();
    }
}

