/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.core;

import fr.lirmm.graphik.util.string.AppendableToStringBuilder;
import java.io.Serializable;

public class Predicate
implements Comparable<Predicate>,
Serializable,
AppendableToStringBuilder {
    public static final Predicate EQUALITY = new Predicate("=", 2);
    public static final Predicate BOTTOM = new Predicate("\u22a5", 1);
    public static final Predicate TOP = new Predicate("\u22a4", 1);
    private static final long serialVersionUID = 3098419922942769704L;
    private final Object identifier;
    private final int arity;

    public Predicate(Object identifier, int arity) {
        this.identifier = identifier;
        this.arity = arity;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public int getArity() {
        return this.arity;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getArity();
        result = 31 * result + (this.getIdentifier() == null ? 0 : this.getIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Predicate)) {
            return false;
        }
        Predicate other = (Predicate)obj;
        if (this.getArity() != other.getArity()) {
            return false;
        }
        return this.getIdentifier().equals(other.getIdentifier());
    }

    @Override
    public int compareTo(Predicate other) {
        int cmpVal;
        int n = this.getArity() < other.getArity() ? -1 : (cmpVal = this.getArity() == other.getArity() ? 0 : 1);
        if (cmpVal == 0) {
            cmpVal = this.getIdentifier().toString().compareTo(other.getIdentifier().toString());
        }
        return cmpVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append(this.getIdentifier()).append('\\').append(this.getArity());
    }
}

