/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.api.forward_chaining;

import fr.lirmm.graphik.integraal.api.core.AtomSet;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.forward_chaining.Chase;
import fr.lirmm.graphik.integraal.api.forward_chaining.ChaseException;
import fr.lirmm.graphik.integraal.api.forward_chaining.RuleApplier;
import fr.lirmm.graphik.integraal.api.util.TimeoutException;
import fr.lirmm.graphik.util.profiler.NoProfiler;
import fr.lirmm.graphik.util.profiler.Profiler;

public abstract class AbstractChase<T1 extends Rule, T2 extends AtomSet>
implements Chase {
    private RuleApplier<T1, ? super T2> ruleApplier;
    private Profiler profiler = NoProfiler.instance();

    protected AbstractChase(RuleApplier<T1, ? super T2> ruleApplier) {
        this.ruleApplier = ruleApplier;
    }

    @Override
    public void execute() throws ChaseException {
        this.getProfiler().start("saturation");
        while (!Thread.currentThread().isInterrupted() && this.hasNext()) {
            this.next();
        }
        this.getProfiler().stop("saturation");
    }

    @Override
    public void execute(long timeout) throws ChaseException, TimeoutException {
        Executor exec = new Executor(this);
        Thread thread = new Thread(exec);
        thread.start();
        try {
            thread.join(timeout);
        }
        catch (InterruptedException e) {
            throw new ChaseException("The chase was interrupted", e);
        }
        if (thread.isAlive()) {
            thread.interrupt();
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new ChaseException("The chase was interrupted", e);
            }
            throw new TimeoutException(timeout);
        }
        if (exec.getException() != null) {
            throw exec.getException();
        }
    }

    protected RuleApplier<T1, ? super T2> getRuleApplier() {
        return this.ruleApplier;
    }

    protected void setRuleApplier(RuleApplier<T1, ? super T2> applier) {
        this.ruleApplier = applier;
    }

    @Override
    public void setProfiler(Profiler profiler) {
        this.profiler = profiler;
    }

    @Override
    public Profiler getProfiler() {
        return this.profiler;
    }

    private static final class Executor
    implements Runnable {
        private ChaseException e = null;
        private Chase chase;

        public Executor(AbstractChase<?, ?> chase) {
            this.chase = chase;
        }

        @Override
        public void run() {
            try {
                this.chase.execute();
            }
            catch (ChaseException ex) {
                this.e = ex;
            }
        }

        ChaseException getException() {
            return this.e;
        }
    }
}

