/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.AbstractSubstitution;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMapBasedSubstitution
extends AbstractSubstitution
implements Substitution {
    protected abstract Map<Variable, Term> getMap();

    @Override
    public Set<Variable> getTerms() {
        return this.getMap().keySet();
    }

    @Override
    public Set<Term> getValues() {
        return new HashSet<Term>(this.getMap().values());
    }

    @Override
    public Term createImageOf(Term term) {
        Term substitut = this.getMap().get(term);
        return substitut == null ? term : substitut;
    }

    @Override
    public boolean put(Variable term, Term substitute) {
        Term actualSubstitute = this.getMap().get(term);
        if (actualSubstitute != null && !actualSubstitute.equals(substitute)) {
            return false;
        }
        this.getMap().put(term, substitute);
        return true;
    }

    @Override
    public boolean remove(Variable term) {
        return this.getMap().remove(term) != null;
    }

    @Override
    public boolean aggregate(Variable term, Term substitut) {
        Term substitutSubstitut;
        Term termSubstitut = this.createImageOf(term);
        if (!termSubstitut.equals(substitutSubstitut = this.createImageOf(substitut))) {
            if (termSubstitut.isConstant()) {
                if (substitutSubstitut.isConstant()) {
                    return substitutSubstitut.equals(termSubstitut);
                }
                Term tmp = termSubstitut;
                termSubstitut = substitutSubstitut;
                substitutSubstitut = tmp;
            }
            for (Variable t : this.getTerms()) {
                Term image = this.createImageOf(t);
                if (!termSubstitut.equals(image) || t.equals(substitutSubstitut)) continue;
                this.getMap().put(t, substitutSubstitut);
            }
            this.getMap().put((Variable)termSubstitut, substitutSubstitut);
        }
        return true;
    }
}

