/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.Substitutions;
import java.util.HashMap;

public class AtomType {
    public static final int VARIABLE = -1;
    public static final int CONSTANT_OR_FROZEN_VAR = -2;
    boolean theAtomContainsAConstant = false;
    boolean multipleOccurrencesOfTheSameVariable;
    int[] type;
    int size;

    public AtomType(Atom atom, Substitution s) {
        this.size = atom.getPredicate().getArity();
        this.type = new int[this.size];
        HashMap<Term, Integer> firstPositionMap = new HashMap<Term, Integer>();
        int i = -1;
        for (Term t : atom) {
            ++i;
            if (t.isConstant() || s.getTerms().contains(t)) {
                this.type[i] = -2;
                this.theAtomContainsAConstant = true;
                this.multipleOccurrencesOfTheSameVariable = true;
                continue;
            }
            Integer firstPos = (Integer)firstPositionMap.get(t);
            if (firstPos == null) {
                firstPositionMap.put(t, i);
                firstPos = -1;
            } else {
                this.multipleOccurrencesOfTheSameVariable = true;
            }
            this.type[i] = firstPos;
        }
    }

    public AtomType(Atom atom) {
        this(atom, Substitutions.emptySubstitution());
    }

    public boolean isThereConstant() {
        return this.theAtomContainsAConstant;
    }

    public boolean isThereConstraint() {
        return this.multipleOccurrencesOfTheSameVariable;
    }
}

