/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.ConjunctiveQueryWithNegatedParts;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.core.factory.DefaultAtomSetFactory;
import java.util.LinkedList;
import java.util.List;

public class DefaultConjunctiveQueryWithNegatedParts
implements ConjunctiveQueryWithNegatedParts {
    private String label;
    private InMemoryAtomSet positiveAtomSet;
    private List<InMemoryAtomSet> negatedParts;
    private List<Term> responseVariables;

    public DefaultConjunctiveQueryWithNegatedParts(InMemoryAtomSet positiveAtomSet, List<InMemoryAtomSet> negatedParts) {
        this("", positiveAtomSet, negatedParts);
    }

    public DefaultConjunctiveQueryWithNegatedParts(String label, InMemoryAtomSet positiveAtomSet, List<InMemoryAtomSet> negatedParts) {
        this("", positiveAtomSet, negatedParts, new LinkedList<Term>(positiveAtomSet.getVariables()));
    }

    public DefaultConjunctiveQueryWithNegatedParts(InMemoryAtomSet positiveAtomSet, List<InMemoryAtomSet> negatedParts, List<Term> ans) {
        this("", positiveAtomSet, negatedParts, ans);
    }

    public DefaultConjunctiveQueryWithNegatedParts(String label, InMemoryAtomSet positiveAtomSet, List<InMemoryAtomSet> negatedParts, List<Term> ans) {
        this.label = label;
        this.positiveAtomSet = positiveAtomSet;
        this.negatedParts = negatedParts;
        this.responseVariables = ans;
    }

    public DefaultConjunctiveQueryWithNegatedParts(ConjunctiveQueryWithNegatedParts query) {
        this(query.getLabel(), DefaultAtomSetFactory.instance().create(query.getPositivePart()), DefaultConjunctiveQueryWithNegatedParts.deepCopy(query.getNegatedParts()), new LinkedList<Term>(query.getAnswerVariables()));
    }

    private static List<InMemoryAtomSet> deepCopy(List<InMemoryAtomSet> sets) {
        LinkedList<InMemoryAtomSet> negParts = new LinkedList<InMemoryAtomSet>();
        for (InMemoryAtomSet set : sets) {
            negParts.add(DefaultAtomSetFactory.instance().create(set));
        }
        return negParts;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public InMemoryAtomSet getPositivePart() {
        return this.positiveAtomSet;
    }

    @Override
    public List<InMemoryAtomSet> getNegatedParts() {
        return this.negatedParts;
    }

    @Override
    public List<Term> getAnswerVariables() {
        return this.responseVariables;
    }

    @Override
    public boolean isBoolean() {
        return this.responseVariables.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendTo(sb);
        return sb.toString();
    }

    @Override
    public void appendTo(StringBuilder sb) {
        sb.append("ANS(");
        boolean first = true;
        for (Term t : this.responseVariables) {
            if (!first) {
                sb.append(',');
            }
            first = false;
            sb.append(t);
        }
        sb.append(") : ");
        sb.append(this.positiveAtomSet);
        for (InMemoryAtomSet atomset : this.negatedParts) {
            sb.append(", \u22a5(");
            sb.append(atomset);
            sb.append(")");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConjunctiveQueryWithNegatedParts)) {
            return false;
        }
        ConjunctiveQueryWithNegatedParts other = (ConjunctiveQueryWithNegatedParts)obj;
        return this.equals(other);
    }

    public boolean equals(ConjunctiveQueryWithNegatedParts other) {
        return this == other;
    }
}

