/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Constant;
import fr.lirmm.graphik.integraal.api.core.InMemoryAtomSet;
import fr.lirmm.graphik.integraal.api.core.Literal;
import fr.lirmm.graphik.integraal.api.core.Rule;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.AbstractRule;
import fr.lirmm.graphik.integraal.core.atomset.DefaultInMemoryAtomSet;
import fr.lirmm.graphik.util.stream.CloseableIteratorWithoutException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public class DefaultRule
extends AbstractRule {
    private String label;
    private InMemoryAtomSet body;
    private InMemoryAtomSet head;
    private Set<Term> terms = null;
    private Set<Variable> variables = null;
    private Set<Constant> constants = null;
    private Set<Literal> literals = null;
    private Set<Variable> frontier = null;
    private Set<Variable> existentials = null;

    public DefaultRule() {
        this("", new DefaultInMemoryAtomSet(), new DefaultInMemoryAtomSet());
    }

    public DefaultRule(CloseableIteratorWithoutException<Atom> body, CloseableIteratorWithoutException<Atom> head) {
        this("", body, head);
    }

    public DefaultRule(String label, CloseableIteratorWithoutException<Atom> body, CloseableIteratorWithoutException<Atom> head) {
        this(label, new DefaultInMemoryAtomSet(body), new DefaultInMemoryAtomSet(head));
    }

    public DefaultRule(InMemoryAtomSet body, InMemoryAtomSet head) {
        this("", body, head);
    }

    public DefaultRule(String label, InMemoryAtomSet body, InMemoryAtomSet head) {
        this.label = label;
        this.body = body;
        this.head = head;
    }

    public DefaultRule(Rule rule) {
        this(rule.getLabel(), (CloseableIteratorWithoutException<Atom>)rule.getBody().iterator(), (CloseableIteratorWithoutException<Atom>)rule.getHead().iterator());
    }

    @Override
    public InMemoryAtomSet getBody() {
        return this.body;
    }

    public void setBody(InMemoryAtomSet b) {
        this.body = b;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public InMemoryAtomSet getHead() {
        return this.head;
    }

    public void setHead(InMemoryAtomSet h) {
        this.head = h;
    }

    @Override
    public Set<Term> getTerms() {
        if (this.terms == null) {
            this.terms = new HashSet<Term>();
            this.terms.addAll(this.getBody().getTerms());
            this.terms.addAll(this.getHead().getTerms());
        }
        return this.terms;
    }

    @Override
    public Set<Variable> getVariables() {
        if (this.variables == null) {
            this.variables = new HashSet<Variable>();
            this.variables.addAll(this.getBody().getVariables());
            this.variables.addAll(this.getHead().getVariables());
        }
        return this.variables;
    }

    @Override
    public Set<Constant> getConstants() {
        if (this.constants == null) {
            this.constants = new HashSet<Constant>();
            this.constants.addAll(this.getBody().getConstants());
            this.constants.addAll(this.getHead().getConstants());
        }
        return this.constants;
    }

    @Override
    public Set<Literal> getLiterals() {
        if (this.literals == null) {
            this.literals = new HashSet<Literal>();
            this.literals.addAll(this.getBody().getLiterals());
            this.literals.addAll(this.getHead().getLiterals());
        }
        return this.literals;
    }

    @Override
    @Deprecated
    public Set<Term> getTerms(Term.Type type) {
        HashSet<Term> terms = new HashSet<Term>();
        terms.addAll(this.getBody().getTerms(type));
        terms.addAll(this.getHead().getTerms(type));
        return terms;
    }

    @Override
    public Set<Variable> getFrontier() {
        if (this.frontier == null) {
            this.computeFrontierAndExistentials();
        }
        return this.frontier;
    }

    @Override
    public Set<Variable> getExistentials() {
        if (this.existentials == null) {
            this.computeFrontierAndExistentials();
        }
        return this.existentials;
    }

    private void computeFrontierAndExistentials() {
        this.frontier = new TreeSet<Variable>();
        this.existentials = new TreeSet<Variable>();
        Set<Variable> body = this.getBody().getVariables();
        for (Variable termHead : this.getHead().getVariables()) {
            boolean isExistential = true;
            for (Variable termBody : body) {
                if (!termBody.equals(termHead)) continue;
                this.frontier.add(termHead);
                isExistential = false;
            }
            if (!isExistential) continue;
            this.existentials.add(termHead);
        }
    }
}

