/*
 * Decompiled with CFR 0.152.
 */
package fr.lirmm.graphik.integraal.core;

import fr.lirmm.graphik.integraal.api.core.Atom;
import fr.lirmm.graphik.integraal.api.core.Substitution;
import fr.lirmm.graphik.integraal.api.core.Term;
import fr.lirmm.graphik.integraal.api.core.Variable;
import fr.lirmm.graphik.integraal.core.DefaultAtom;
import fr.lirmm.graphik.integraal.core.EmptySubstitution;
import fr.lirmm.graphik.integraal.core.TreeMapSubstitution;
import fr.lirmm.graphik.integraal.core.factory.DefaultSubstitutionFactory;
import fr.lirmm.graphik.util.Partition;
import java.util.LinkedList;

public final class Substitutions {
    private Substitutions() {
    }

    public static Substitution emptySubstitution() {
        return EmptySubstitution.instance();
    }

    public static Substitution add(Substitution s1, Substitution s2) {
        TreeMapSubstitution newSub = new TreeMapSubstitution(s1);
        for (Variable term : s2.getTerms()) {
            if (newSub.put(term, s2.createImageOf(term))) continue;
            return null;
        }
        return newSub;
    }

    public static Partition<Term> toPartition(Substitution s) {
        Partition<Term> partition = new Partition<Term>();
        for (Variable v : s.getTerms()) {
            partition.add(v, s.createImageOf(v));
        }
        return partition;
    }

    public static Atom createImageOf(Atom atom, Variable var, Term image) {
        LinkedList<Term> termsSubstitut = new LinkedList<Term>();
        for (Term t : atom.getTerms()) {
            if (var.equals(t)) {
                termsSubstitut.add(image);
                continue;
            }
            termsSubstitut.add(t);
        }
        return new DefaultAtom(atom.getPredicate(), termsSubstitut);
    }

    public static Substitution aggregate(Substitution s1, Substitution s2) {
        Substitution newSub = DefaultSubstitutionFactory.instance().createSubstitution(s1);
        for (Variable term : s2.getTerms()) {
            if (newSub.aggregate(term, s2.createImageOf(term))) continue;
            return null;
        }
        return newSub;
    }
}

